// -----------------------------	
// Stephen Snudden 
// ssnudden@wlu.ca
// December 2025
// -----------------------------	

// ****************
//  INTRO 

clear all
capture drop _all
capture log close
set more off
timer on 1
set linesize 255

// ****************
//  Lists

// Variable list with all countries with data from 1994
*local idlist94 "alb aut bdi bel ben bfa bgd bgr bhs bol bra bwa can che chl chn cmr col cze deu dnk dom dza ecu egy esp eth fin fji fra gab gbr gha grc gtm hnd hun idn ind irl isl isr ita jam jor jpn ken kor kwt lka lux mar mex mrt mus mys ner nld nor pak pan per phl pol prt pry rou sau sgp slb slv svk swe tha ton tun tur uga ury usa zaf"

// Variable list with all countries with data from 1993
*local idlist93 "aut bel bhs bra bwa can che chl chn cmr col cze deu dnk egy esp eth fin fji fra gab gbr grc gtm idn ind irl isl isr ita jam jor jpn ken kor kwt lka lux mar mex mys nld nor pak pan per phl prt pry rou sau sgp swe tha ton tun tur usa zaf"

// Missing data post 2021: mrt
// Missing: aus vut

// FIXED FX: BHS PAN SAU SLV
local exclude_ner "bhs pan sau slv bol"
local idlist_test "usa chl"

// Variable list with select flexiable EER countires
local idlistfew "jpn usa chl col isr nld nor gbr deu " //  
// Variable list with countires with data starting at or before 1993
local idlist93 "`idlistfew' aut bel bhs bra bwa can che chn cmr cze dnk egy esp eth fin fji fra gab grc gtm idn ind irl isl ita jam jor ken kor kwt lka lux mar mex mys pak pan per phl prt pry rou sau sgp swe tha ton tun tur zaf"
// Variable list with countires with data starting in 1994
local idlist94 "`idlist93' alb bdi ben bfa bgd bgr bol dom dza ecu gtm hnd hun mus ner pol slb slv svk uga ury"

// Comment me in for a quick test run 
*local idlist94 "`idlist_test'"

// Choose ER measures to forecast
local ratelist "REER NEER " // RER NER
foreach rate in `ratelist' {

// ****************
//  No-Change Forecasts
// IMPUTS: ctry starty endy rate
//*
putexcel set `rate'results, sheet("No-Change", replace) modify
local rr=2
foreach ctry in `idlist94' {
qui do "compiledaily.do" `ctry' 2004 2022 `rate'
qui do "compilebench.do" `ctry' 2004 2022 `rate'
capture do "LastdayNC/LASTDNC.do" `ctry' 2004 1 2022 1 `rr' 
clear all
display "`ctry'"
local  rr=`rr'+1
}
translate logfile.smcl "LastdayNC/log_`rate'_NC.log", replace
*/

// Exclude fixed rate countries from model-based forecasts
// Faster but not needed - results line in Results.xlxs file will be blank if forecasts fail
if "`rate'"=="NER" {
	*local idlist94: list idlist94 - exclude_mod
}

// ****************
//  ARIMA FORECASTS
//*
// IMPUTS: starty endy outputrow PEPS=1 AR(p) MA(q)
local rr=2  
foreach ctry in `idlist94' {
do "compiledaily.do" `ctry' 2004 2022 `rate'
do "compilebench.do" `ctry' 2004 2022 `rate'
putexcel set `rate'results, sheet("AR1") modify
capture  do "ARIMA/ARIMA.do" `ctry' 2004 1 2022 1 `rr' 0 1 0
clear all
putexcel set `rate'results, sheet("PEPS_AR1") modify
capture do "ARIMA/ARIMA.do" `ctry' 2004 1 2022 1 `rr' 1 1 0
clear all
putexcel set `rate'results, sheet("AR1_PC") modify
capture do "ARIMA/ARIMA_PC.do" `ctry' 2004 1 2022 1 `rr' 0 1 0 
clear all
putexcel set `rate'results, sheet("PEPS_AR1_PC") modify
capture do "ARIMA/ARIMA_PC.do" `ctry' 2004 1 2022 1 `rr' 1 1 0 
clear all
local  rr=`rr'+1
}
translate logfile.smcl "ARIMA/log_`rate'_ARIMA_1.log", replace //
*/

// ****************
//  DIRECT FORECASTS
//*
// IMPUTS: stary endy row PEPS=1 LVL=1 CON=1 MIDAS=1 MIDASLAGS=1or12 constant
local rr=2
foreach ctry in `idlist94' {
// Gen ctry data
do "compiledailymidas.do" `ctry' 2004 2022 `rate' 1
do "compilebench.do" `ctry' 2004 2022 `rate'
// MIDAS forecasts 
do "MIDAS/gendata.do" `ctry' 2004 2022 1 1 1
/*
putexcel set `rate'results, sheet("MIDAS_J1_LVL") modify
capture do "MIDAS/MIDAS.do" `ctry' 2004 1 2022 1 `rr' 0 1 1 1
clear all
putexcel set `rate'results, sheet("DPEP_J1_LVL") modify
capture do "MIDAS/MIDAS.do" `ctry' 2004 1 2022 1 `rr' 1 1 1 1
clear all
putexcel set `rate'results, sheet("DIRECT_J1_LVL") modify
capture do "MIDAS/MIDAS.do" `ctry' 2004 1 2022 1 `rr' 0 1 1 0
clear all
*/
// Forecasts without constant
//*
// MIDAS forecasts 
do "MIDAS/gendata.do" `ctry' 2004 2022 1 2 0
putexcel set `rate'results, sheet("MIDAS_J1_LVL_NOCON") modify
capture do "MIDAS/MIDAS.do" `ctry' 2004 1 2022 1 `rr' 0 1 0 1
clear all
putexcel set `rate'results, sheet("DPEP_J1_LVL_NOCON") modify
capture do "MIDAS/MIDAS.do" `ctry' 2004 1 2022 1 `rr' 1 1 0 1
clear all
putexcel set `rate'results, sheet("DIRECT_J1_LVL_NOCON") modify
capture do "MIDAS/MIDAS.do" `ctry' 2004 1 2022 1 `rr' 0 1 0 0
clear all
*/
local  rr=`rr'+1
}
*/
 
// ****************
//  BOTTOM-UP RECURSIVE FORECASTS
//*
// IMPUTS: stary endy row PEPS=1 LVL=1 CON=1 MIDAS=1
local rr=2
foreach ctry in `idlist94' {
do "compiledaily.do" `ctry' 2004 2022 `rate'
do "compilebench.do" `ctry' 2004 2022 `rate'
putexcel set `rate'results, sheet("BU_AR1") modify
capture do "BottomUP/DAILY.do" `ctry' 2004 1 2022 1 `rr' 1 0
clear all
putexcel set `rate'results, sheet("BU_AR1_PC") modify
capture do "BottomUP/DAILY_PC.do" `ctry' 2004 1 2022 1 `rr' 1 0
clear all
local  rr=`rr'+1
}
*/

// ****************
//  FINISH
} // Rates

timer off 1
noisily: timer list 1

