################# MULTIPLY NER AND CPI AS STEPPING STONE TO REERs ############################################

# ner expresses the value of a country's currency in terms of USD
# cpi is a measure of the level of cpi in a country in units of their own currency
# ner*cpi is a measure of the level of cpi in terms of USD
multiply_ner_and_cpi_for_country <- function(country_name, ner, cpi) {
  # Extract data for the country of interest
  if(!(country_name %in% names(ner)) | !(country_name %in% names(cpi))) {
    return(NA)
  } else {
    ner_country <- ner[[country_name]]
    cpi_country <- cpi[[country_name]]
  }
  
  # If ner and cpi are both daily, both monthly, or both quarterly, we can just multiply them together
  if(class(index(ner)) == class(index(cpi))) {
    return(ner_country*cpi_country)
  } else {
    stop("ner and cpi must be zoo objects whose indexes are of the same class")
  }
}
multiply_ner_and_cpi_for_vintage <- function(vintage_name, ner, cpi_directory, write_folder) {
  cpi <- readRDS(paste0(cpi_directory, vintage_name, ".rds"))
  country_names <- intersect(names(ner), names(cpi))
  fx_list <- map(country_names, multiply_ner_and_cpi_for_country, ner = ner, cpi = cpi)
  names(fx_list) <-  country_names
  Filter(function(x) any(!is.na(x)), fx_list) %>%
    saveRDS(paste0("Mid_data/FX/Bilateral_NER_CPI/", write_folder, "/", vintage_name, ".rds"))
}