make_EAER_2020_df <- function(EAER_currency, EAER_classification, EAER_anchor) {
  make_2020_df <- function(EAER_zoo) {
    zoo_2020 <- window(EAER_zoo, start = 2020, end = 2020)
    data.frame(country = names(zoo_2020), as.character(zoo_2020))
  }
  wide_df <- merge(make_2020_df(EAER_currency), merge(make_2020_df(EAER_classification), make_2020_df(EAER_anchor), by = "country"), by = "country")
  colnames(wide_df) <- c("country", "Currency", "Classification", "Anchor")
  wide_df$Classification <- factor(wide_df$Classification,
                                   levels = c("Free floating", "Floating", "Crawl-like arrangement", "Crawling peg", "Pegged exchange rate within horizontal bands",
                                              "Stabilized arrangement", "Conventional peg", "Currency board", "No separate legal tender", "Other managed arrangement"))
  wide_df$Anchor <- factor(wide_df$Anchor, levels = c("U.S. dollar", "Euro", "Composite", "Other", "Not in any category"), labels = c("USD", "EUR", "Composite", "Other anchor", "No anchor"))
  return(wide_df)
}
