######################## COMPUTE PERIOD-AVERAGE NERs ############################

count_zoo_length <- function(z) {last(index(z)) - first(index(z)) + 1}

# Compute month-averages
compute_m_avg <- function(z) {
  z <- trim_partial_month(z) # We remove any daily data covering part of a month at the start or end
  if(length(unique(as.yearmon(index(z)))) <= 2) {return(NULL)} # We only compute month-averages if there at least 2 months of data
  zoo:::aggregate.zoo(z, by = as.yearmon, FUN = mean, na.rm = F)
}

# Compute quarter-averages. By computing a quarter-average of dailies, I put more weight on months with more observations, which is appropriate
compute_q_avg <- function(z) {
  z <- trim_partial_quarter(z) # Remove any daily data covering part of a quarter at the start or end
  if(length(unique(as.yearqtr(index(z)))) <= 2) {return(NULL)} # We only compute quarter-averages if there at least 2 quarters of data
  zoo:::aggregate.zoo(z, by = as.yearqtr, FUN = mean, na.rm = F)
}

######################### EXTRACT PERIOD-END NERs ###############################

# Define function that checks if a yearmon is at the end of a quarter
check_if_mon_is_end_qtr <- function(yearmon) {month(yearmon) %in% c(3, 6, 9, 12)}

# Define function that checks if a date is at the end of a month or end of a quarter
check_if_date_is_end_mon <- function(date) {date==(ceiling_date(date, unit = "months") - 1)}
check_if_date_is_end_qtr <- function(date) {date==(ceiling_date(date, unit = "quarters") - 1)}

# For each zoo object in a list, extract only the observations at the end of a month or quarter
extract_end_period_values <- function(zoo_list, desired_index_class) {
  # Put all countries into a single zoo object
  zoo_merge <- do.call(merge.zoo, zoo_list)
  
  # If the user wants end-of-quarter values, extract the last month of each quarter or last day of quarter
  if(desired_index_class == "yearqtr") {
    if(class(index(zoo_merge)) == "yearmon") {zoo_end_period <- zoo_merge[unlist(map(index(zoo_merge), check_if_mon_is_end_qtr))]}
    if(class(index(zoo_merge)) == "Date") {zoo_end_period <- zoo_merge[unlist(map(index(zoo_merge), check_if_date_is_end_qtr))]}
    index(zoo_end_period) <- as.yearqtr(index(zoo_end_period))
  }
  
  # If the user wants end-of-month values, extract the last day of each month
  if(desired_index_class == "yearmon") {
    if(class(index(zoo_merge)) == "Date") {zoo_end_period <- zoo_merge[unlist(map(index(zoo_merge), check_if_date_is_end_mon))]}
    index(zoo_end_period) <- as.yearmon(index(zoo_end_period))
  }
  
  # Separate all countries into their own zoo objects
  map(as.list(zoo_end_period), function(x) na.trim(x, sides = "both", is.na = "all"))
}