# For each month, compute chained EERs using all NER, CPI and weights data up to that month
# These will be used as input into our models
compute_chained_eer_for_vintage_wrapper <- function(vintage_name, weights_vintages, weights_lag_in_months, read_fx_directory, write_EER_directory) {
  library(zoo)
  library(tidyverse)
  library(lubridate)
  source('Code/Tidy_fx_functions/compute_EER.R')
  source('Code/Tidy_functions/remove_null.R')
  compute_chained_eer_for_vintage(vintage_name = vintage_name, weights_vintages = weights_vintages, weights_lag_in_months = weights_lag_in_months, read_fx_directory = read_fx_directory) %>%
    saveRDS(paste0(write_EER_directory, vintage_name, ".rds"))
}

# Using the latest vintage with NER and CPi data (Sep 2022), compute chained EERs using all NER and CPI data, but only weights up to a specified weight
# E.g. We compute chained EERs with all weights up to the 1996-1998 vintage.
# We will use these as actuals when computing errors
compute_eer_actuals_wrapper <- function(max_weights_vintage_name, weights_vintages, read_fx_directory, write_EER_directory) {
  library(zoo)
  library(tidyverse)
  library(lubridate)
  source('Code/Tidy_fx_functions/compute_EER.R')
  source('Code/Tidy_functions/remove_null.R')
  chained_EER <- compute_chained_eer_for_vintage(vintage_name = "Sep 2022",
                                                 weights_vintages = weights_vintages[1:which(max_weights_vintage_name == names(weights_vintages))],
                                                 weights_lag_in_months = 0,
                                                 read_fx_directory = read_fx_directory)
  # If we are computing REERs, we only treat data up to 31 July 2022 as actuals
  # The reason is that, in the NER*CPI data, the data from August 2022 is typically computed with CPIs that I extrapolated forward
  if(grepl("REER", write_EER_directory)) {
    if (class(index(chained_EER[[1]]))=="Date") {
      chained_EER <- map(chained_EER, function(z) window(z, start = NULL, end = as.Date("2022-07-31")))
    } else if (class(index(chained_EER[[1]]))=="yearmon") {
      chained_EER <- map(chained_EER, function(z) window(z, start = NULL, end = as.yearmon("Jul 2022")))
    } else {
      stop("compute_eer_actuals_wrapper only supports chained_EER with date or yearmon index")
    }
  }
  saveRDS(chained_EER, paste0(write_EER_directory, max_weights_vintage_name, ".rds"))
}
