
import_wb_cpi <- function(path, sheet, country_facts) {
  # Import the Excel tab with monthly headline CPI levels
  raw <- read.xlsx(path, sheet = sheet, startRow = 1, colNames = F, rowNames = F)
  
  # Extract the numbers, which I call coredata
  coredata <- raw[2:nrow(raw), 6:(ncol(raw)-1)]
  
  # Each row corresponds to a country, so extract the country names from country_facts
  iso_codes <- raw[2:nrow(raw), 1]
  country_names <- unlist(map(iso_codes, function(x) if(x %in% country_facts$iso) {return(country_facts[x == country_facts$iso, "country"])} else {return(NA)}))
  
  # Each column corresponds a month and year, so convert them to yearmon
  convert_string_to_yearmon <- function(x) {as.yearmon(paste(month.abb[as.integer(substr(x, start = 5, stop = 6))], substr(x, start = 1, stop = 4)))}
  yearmons <- do.call(c, map(raw[1, 6:(ncol(raw)-1)], convert_string_to_yearmon))
  
  # Retain data only for countries whose country names I could identify
  df <- as.data.frame(t(coredata))
  colnames(df) <- country_names
  has_name_df <- df[ , !is.na(colnames(df))]
  
  # Retain only columns that have at least one non-NA value
  select_df <- do.call(merge.zoo, Filter(function(z) any(!is.na(z)), as.list(has_name_df)))
  colnames(select_df) <- gsub("\\.1", "", colnames(select_df))

  # Convert the data to a zoo object
  return(zooreg(select_df, order.by = yearmons, frequency = 12))
}