
coarse_classifier <- function(code) {
  case_when(
    code == 1 ~ "Peg",
    code == 2 ~ "Crawling",
    code == 3 ~ "Managed float",
    code == 4 ~ "Free float",
    code == 5 ~ "Free falling",
    code == 6 ~ "Dual market"
  )
}
import_ilzetzki_codes <- function(country_facts, sheet) {
  ### Import data
  raw <- read.xlsx("Raw_data/Ilzetzki_data/ERA_Classification_Monthly_1940-2019.xlsx",
                   sheet = sheet, startRow = 5, colNames = FALSE, rowNames = FALSE)
  
  ### Prepare country names
  
  # Extract country names
  raw_country_names <- map2(raw[1, 3:ncol(raw)],
                            raw[2, 3:ncol(raw)],
                            function(x, y) if(!is.na(x)) {return(paste(x, y))} else {return(y)})
  
  # Put the country names in the same format as in country_facts
  tidy_country_names <- str_to_title(trimws(raw_country_names))
  country_names <- str_replace(tidy_country_names, "&", "And") %>%
    str_replace_all("   ", " ") %>%
    str_replace_all("  ", " ") %>%
    str_replace_all("Rep\\.", "Republic") %>%
    str_replace("Azerbaijan Republic Of", "Azerbaijan") %>%
    str_replace("Bahrain Kingdom Of", "Bahrain") %>%
    str_replace("The Bahamas", "Bahamas, The") %>%
    str_replace("China, Pr", "China") %>%
    str_replace("Congo Dem\\. Republic Of", "Congo, Democratic Republic Of The") %>%
    str_replace("Congo Republic Of", "Congo, Republic Of") %>%
    str_replace("Cote D\"Ivoire", "Côte D'ivoire") %>%
    str_replace("The Gambia", "Gambia, The") %>%
    str_replace("Guinea Bissau", "Guinea-Bissau") %>%
    str_replace("Hong Kong", "Hong Kong Sar") %>%
    str_replace("Lao Dem\\. Republic", "Lao P.d.r.") %>%
    str_replace("Macao", "Macao Sar") %>%
    str_replace("Macedonia Fyr", "North Macedonia") %>%
    str_replace("Montenegro", "Montenegro, Rep. Of") %>%
    str_replace("Png", "Papua New Guinea") %>%
    str_replace("Sao Tome And Principe", "São Tomé And Príncipe") %>%
    str_replace("Serbia, Republic Of", "Serbia") %>%
    str_replace("St Vincent And Grenadines", "St. Vincent And The Grenadines") %>%
    str_replace("Swaziland", "Eswatini") %>%
    str_replace("Syrian Arab Republic", "Syria") %>%
    str_replace("Trinidad Tobago", "Trinidad And Tobago") %>%
    str_replace("Uae", "United Arab Emirates") %>%
    str_replace("Yemen Republic Of", "Yemen")
    
  ### Prepare yearmon labels
  periods <- raw[3:nrow(raw),2]
  years <- map(periods, function(x) substr(x, start = 1, stop = 4))
  months <- map(periods, function(x) substr(x, start = 6, stop = 7))
  nice_periods <- map2(years,
                       months,
                       function(x, y) as.yearmon(as.Date(paste(x, y, 1), format = "%Y %m %d")))
  
  ### Create a nice zoo object
  z <- zooreg(raw[3:nrow(raw), 3:ncol(raw)], order.by = do.call(c, nice_periods))
  colnames(z) <- country_names
  
  ### Make the labels descriptive
  if (sheet == "Coarse") {
    classify_country <- function(country_zoo) {
      labelled <- unlist(map(country_zoo, coarse_classifier))
      return(zooreg(labelled, order.by = index(country_zoo)))
    }
    return(do.call(merge.zoo, map(as.list(z), classify_country)))
  } else if (sheet == "Fine") {
    warning("I still haven't written a fine_classifier")
    return(z)
  }
}
