// -----------------------------	
// Stephen Snudden May 2023
// -----------------------------	

//*********
//Intro formalities

args var starty mms endy mme rr p q
set more off
set matsize 800 

//***************************
// PERCENT CHANGE 

clear all 
use DataD
tsappend, add(1200)

// -----------------------------	
// Out-of-sample several-step ahead forecasts vs random walk
// KEEP AS LN-LEVEL OF THE REAL PRICE
//*
  // Save dates
  local syear=year[1] 
  local smonth=month[1]
  
  // Set dates. 
  local startdate = td(31jan`starty')  
  local enddate = td(31jan`endy')  
  local adj = time[_n==1]-1
  local start = `startdate'-`adj'
  
  local mm=`mms' // month to start
  local aa=`starty'
  local start0= `start' 
  local startd=`start0'+1  // Set one step ahead 
  local end= `enddate'-`adj'
  
  // Construct series
  foreach i of numlist 1 {
    local dateme = `start0'+`i'
    local datemet = `start0'+30
    local endme = `end'+`i'-1
    local endmet = `end'-`i'-1
  }
	// Calculate forecasts// we have a loop within a loop// START HERE after last meeting
  while  `start0'<=`end' {
   if chk[`start0']>1 & chk[`start0']<. {
    //Generate real time data 
	*qui csipolate ei_`mm'_`aa' t, generate(icei_`mm'_`aa') 
	*ipolate ei_`mm'_`aa' t, generate(ilei_`mm'_`aa') 
	qui gen eer_rt= ei_`mm'_`aa' in 1/`start0' // Daily nominal data
    qui gen dleer=100*(eer_rt/L.eer_rt-1)
    // Recursive dynamic of AR(p) in levels
    *qui arima dleer in 1/`start0', ar(1/`p') ma(1)
    *qui predict f_dleer, dynamic(`startd') 
	// Recursive dynamic of AR(p) in levels
    qui regress dleer l(1/`p').dleer in 1/`start0'
    qui estimates store yhat
    qui forecast create oilmodel, replace
    qui forecast estimates yhat
    qui forecast solve, prefix(f_) begin(`start0') periods(1200) 
    // Convert to REAL LEVELS
    qui gen f_eer = eer_rt in 1/`start0'
    qui replace f_eer = (f_dleer/100+1)*L.f_eer if _n>`start0'
    // Convert to real levels
    qui gen f_`p'_eer_`mm'_`aa'=f_eer
    // Drop Variables
    drop eer_rt f_eer dleer f_dleer // icei_`mm'_`aa' // ei_`mm'_`aa'
	qui bys year month : egen fm_`p'_eer_`mm'_`aa' = mean(f_`p'_eer_`mm'_`aa')
	qui tsset mydate
    // Update real time data by one period
    if `mm'<12 { 
       local mm=`mm'+1 
    } 
    else if `mm'==12 { 
      local mm=1 
      local aa=`aa'+1 
    }
   } // update day
    local start0=`start0'+1
    local startd=`startd'+1
  } // date

save "Forecasts.dta", replace

drop if missing(chk)
save "ForecastsM.dta", replace
*/
// *********
// PART 2: Forecast Evaluation
// *********

//*********
// Load Data

clear all
// Daily forecasts
use "ForecastsM.dta"
keep month year fm_*
gen time=tm(`syear'm`smonth')+ _n-1
format time %tm
qui tsset time
qui merge 1:m time using "DataM.dta", nogenerate
qui save "Data.dta", replace
format time %tm
qui tsset time
  
tsset time
gen t=_n   

tsappend, add(30)


  // Set dates. 
  local mm=`mms' // month to start
  local aa=`starty' // year to start
  local startdate = "`aa'm`mm'"
  local enddate = "`endy'm`mme'" // year and month to end

  //Note: In Stata default for time is 0 at 1960m1: see tsset.  Need to adjust.
  local adj = time[_n==1]-1
  local start = tm(`startdate')-`adj'
  local start0=`start'
  local startd=tm(`startdate')+1 // Set one step ahead
  local end=tm(`enddate')-`adj'+1 // last forecast date

  // Construct series
  foreach i of numlist 1 3 6 12 24 36 {
    local dateme = `start0'+`i'
    local datemet = `start0'+30
    local endme = `end'+`i'-1
    local endmet = `end'-`i'-1
    qui gen sign`i'=0 in `dateme'/`endme'
    qui gen signl`i'=0 in `dateme'/`endme'
    qui gen signy`i'=0 in `dateme'/`endme'
    qui gen signyl`i'=0 in `dateme'/`endme'
    qui gen signf`i'=0 in `dateme'/`endme'
    qui gen signfl`i'=0 in `dateme'/`endme'
    qui gen error_a`i'=0 in `dateme'/`endme'
    qui gen error_l`i'=0 in `dateme'/`endme'
    qui gen error_rw`i'=0 in `dateme'/`endme'
    qui gen arfor`i'=0 in `dateme'/`endme'
    qui gen rwfor`i'=0 in `dateme'/`endme'
    qui gen actual`i'=0 in `dateme'/`endme'
  }
  
  while  `start0'<`end' {
  	// Realtime data
	qui gen eer_rt= ave_`mm'_`aa'
    qui gen eer_last= ld_`mm'_`aa'
	// Target
	gen eer=tar_`aa'
    gen eer_lastday=tar_ld_`aa'
    //get forecast
	qui gen eer_f=fm_`p'_eer_`mm'_`aa'
    // Real time no-change 
    qui gen eer_rw = eer_rt[`start0']
    qui gen eer_ld = eer_last[`start0']
    // Save statistics
    foreach i of numlist 1 3 6 12 24 36 {
      local sdate = `start0'+`i'
      // Model forecast
      qui replace arfor`i'=eer_f in `sdate'/`sdate'
      // Random walk forecast
      qui replace rwfor`i'=eer_rw in `sdate'/`sdate'
      // Actual
      qui replace actual`i'=eer in `sdate'/`sdate' 
      // Error
      qui replace error_a`i'=eer-eer_f in `sdate'/`sdate'
      // Error ld
      qui replace error_l`i'=eer-eer_ld in `sdate'/`sdate'
      // Random walk
      qui replace error_rw`i'=eer-eer_rw in `sdate'/`sdate'
      // Calc Success Ratios
      qui replace sign`i'=1 if eer - l`i'.eer >0 & eer_f - l`i'.eer_rt >0 in `sdate'/`sdate'
      qui replace sign`i'=1 if eer - l`i'.eer <0 & eer_f - l`i'.eer_rt <0 in `sdate'/`sdate'
      qui replace signl`i'=1 if eer - l`i'.eer_lastday >0 & eer_f - l`i'.eer_last >0 in `sdate'/`sdate'
      qui replace signl`i'=1 if eer - l`i'.eer_lastday <0 & eer_f - l`i'.eer_last <0 in `sdate'/`sdate'
      qui replace signy`i'=1 if eer - l`i'.eer >0 in `sdate'/`sdate'
      qui replace signyl`i'=1 if eer - l`i'.eer_lastday >0 in `sdate'/`sdate'
      qui replace signf`i'=1 if eer_f - l`i'.eer_rt >0 in `sdate'/`sdate'
      qui replace signfl`i'=1 if eer_f - l`i'.eer_last >0 in `sdate'/`sdate'
    }
    // Drop Variables
    drop eer_f eer_rw eer_rt eer_ld eer_last eer_rt eer_lastday eer
    // Update step by one period
    local start0=`start0'+1
    local startd=`startd'+1
    // Update real time data by one period
    if `mm'<12 { 
      local mm=`mm'+1 
    } 
    else if `mm'==12 { 
      local mm=1 
      local aa=`aa'+1 
    }
  } // date
  qui drop if _n>`end'
  foreach i of numlist 1 3 6 12 24 36 {
    qui gen error_asq`i' = error_a`i'^2
    qui gen error_lsq`i' = error_l`i'^2
    qui gen error_rwsq`i' = error_rw`i'^2
  } // h
  
  // AFTER THE MODEL FORECAST SUMMARIZE CRITERION
   // Ratio of MSPE of VAR to Random Walk 
    foreach i of numlist 1 3 6 12 24 36 {
	    qui summarize error_asq`i' 
        qui scalar mspet_ar`i' = r(mean)
	    qui summarize error_lsq`i' 
        qui scalar mspet_ld`i' = r(mean)
        qui summarize error_rwsq`i' 
        qui scalar mspet_rw`i' = r(mean)
	    qui scalar obs`i' = r(N)
        local nlags = round(4*(obs`i'/100)^(2/9))
	    //Diebold-Mariano Test following Killian et al
        capture drop dif
        qui gen dif=error_rwsq`i'-error_asq`i' 
        qui newey dif, lag(`nlags')
        matrix M=r(table)
        scalar beta= M[1,1]
	    scalar nwerr= M[2,1]
	    scalar teststat=beta/nwerr
	    scalar pt`i'=1-normal(teststat)
        matrix drop M
	    //Last day
        capture drop difl
        qui gen difl=error_lsq`i'-error_asq`i'
        qui newey difl, lag(`nlags')
        matrix M=r(table)
        scalar beta= M[1,1]
	    scalar nwerr= M[2,1]
	    scalar teststat=beta/nwerr
	    scalar pt_l`i'=1-normal(teststat)
        matrix drop M
	} // h
  
  //Success Ratios
  foreach i of numlist 1 3 6 12 24 36 {
	//Success Ratios Using Pesaran Timmermann 2009 vs AVE
    qui summarize sign`i' 
	qui scalar phat`i' = r(mean)
	qui scalar obs`i' = r(N)
    local nlags = round(4*(obs`i'/100)^(2/9))
	qui newey signy`i' signf`i', lag(`nlags')
    matrix M=r(table)
	scalar beta= M[1,1]
	scalar nwerr= M[2,1]
	scalar teststat=beta/nwerr
	scalar ptsr`i'=1-normal(teststat)
    matrix drop M
	//Success Ratios Using Pesaran Timmermann 2009 vs LD
	qui summarize signl`i' 
	qui scalar phat_l`i' = r(mean)
	qui scalar obs`i' = r(N)
    local nlags = round(4*(obs`i'/100)^(2/9))
	qui newey signyl`i' signfl`i', lag(`nlags')
    matrix M=r(table)
	scalar beta= M[1,1]
	scalar nwerr= M[2,1]
	scalar teststat=beta/nwerr
	scalar ptsr_l`i'=1-normal(teststat)
    matrix drop M
    }
	
  putexcel A`rr'= " `var' "
  quietly {  
  log using logfile, append
  noisily: display "    "
 
  noisily: display "`var': BOTTOM-UP FORECASTS OF AR(`p'), PERCENT CHANGE" 
  
  noisily: display " vs AVE"
  // DISPLAY FINAL OBS MSPE AND P-VALUES
  foreach i of numlist 1 3 6 12 24 36  {
    capture drop dif difl
    drop error_a`i' error_l`i' error_rw`i' error_asq`i' error_lsq`i' error_rwsq`i' arfor`i' rwfor`i' actual`i'
    noisily: display "MSPE`i' vsAVE" _s(1) round(mspet_ar`i'/mspet_rw`i',.001) _s(1) round(pt`i',.001) 
    scalar amsperat`i'=round(mspet_ar`i'/mspet_rw`i',.001)   
    scalar apmsperat`i'=round(pt`i',.001)    
  }
  
    // DISPLAY FINAL OBS SR AND P-VALUES
  foreach i of numlist 1 3 6 12 24 36  {
    drop signy`i' signyl`i' signl`i' signf`i' signfl`i'  sign`i'
    noisily: display "SR`i' vsAVE" _s(1) round(phat`i',.001) _s(1) round(ptsr`i',.001)
	scalar aprat`i'=round(phat`i',.001)
	scalar apprat`i'=round(ptsr`i',.001)
  }   

  noisily: display " vs LD"
  foreach i of numlist 1 3 6 12 24 36  {
     noisily: display "MSPE`i' vsLD" _s(1) round(mspet_ar`i'/mspet_ld`i',.001) _s(1) round(pt_l`i',.001)
    scalar msperat`i'=round(mspet_ar`i'/mspet_ld`i',.001)   
    scalar pmsperat`i'=round(pt_l`i',.001)    
  }

  foreach i of numlist 1 3 6 12 24 36  {
    noisily: display "SR`i' vsLD" _s(1) round(phat_l`i',.001) _s(1) round(ptsr_l`i',.001) 
	scalar prat`i'=round(phat_l`i',.001)
	scalar pprat`i'=round(ptsr_l`i',.001)
  } 
  
  log close

  }
  putexcel B`rr'=msperat1
  putexcel C`rr'=msperat3
  putexcel D`rr'=msperat6
  putexcel E`rr'=msperat12
  putexcel F`rr'=msperat24
  putexcel G`rr'=msperat36
  putexcel H`rr'=prat1
  putexcel I`rr'=prat3
  putexcel J`rr'=prat6
  putexcel K`rr'=prat12
  putexcel L`rr'=prat24
  putexcel M`rr'=prat36
  putexcel N`rr'=pmsperat1
  putexcel O`rr'=pmsperat3
  putexcel P`rr'=pmsperat6
  putexcel Q`rr'=pmsperat12
  putexcel R`rr'=pmsperat24
  putexcel S`rr'=pmsperat36
  putexcel T`rr'=pprat1
  putexcel U`rr'=pprat3
  putexcel V`rr'=pprat6
  putexcel W`rr'=pprat12
  putexcel X`rr'=pprat24
  putexcel Y`rr'=pprat36

  putexcel AB`rr'=amsperat1
  putexcel AC`rr'=amsperat3
  putexcel AD`rr'=amsperat6
  putexcel AE`rr'=amsperat12
  putexcel AF`rr'=amsperat24
  putexcel AG`rr'=amsperat36
  putexcel AH`rr'=aprat1
  putexcel AI`rr'=aprat3
  putexcel AJ`rr'=aprat6
  putexcel AK`rr'=aprat12
  putexcel AL`rr'=aprat24
  putexcel AM`rr'=aprat36
  putexcel AN`rr'=apmsperat1
  putexcel AO`rr'=apmsperat3
  putexcel AP`rr'=apmsperat6
  putexcel AQ`rr'=apmsperat12
  putexcel AR`rr'=apmsperat24
  putexcel AS`rr'=apmsperat36
  putexcel AT`rr'=apprat1
  putexcel AU`rr'=apprat3
  putexcel AV`rr'=apprat6
  putexcel AW`rr'=apprat12
  putexcel AX`rr'=apprat24
  putexcel AY`rr'=apprat36


clear all
