// -----------------------------	
// Stephen Snudden June 2023
// -----------------------------	

//*********
//Intro formalities

args var starty mms endy mme pp last p q a
clear all

capture drop _all
set more off
set maxiter 50

//***************************

  use DataM
  tsappend, add(70)
  set more off

  // Set dates. 
  local mm=`mms' // month to start
  local aa=`starty' // year to start
  local startdate = "`aa'm`mm'"
  local enddate = "`endy'm`mme'" // year and month to end
  
  //Note: In Stata default for time is 0 at 1960m1: see tsset.  Need to adjust (adj) 
  local adj = time[_n==1]-1
  local start = tm(`startdate')-`adj'
  local start0=`start'
  local startd=tm(`startdate')+1 // Set one step ahead
  local end=tm(`enddate')-`adj'+1 // last forecast date
  
  // Construct series
  foreach i of numlist 1 3 6 12 24 36{
    local dateme = `start0'+`i'
    local datemet = `start0'+30
    local endme = `end'+`i'-1
    local endmet = `end'-`i'-1
    qui gen sign`i'=0 in `dateme'/`endme'
    qui gen signl`i'=0 in `dateme'/`endme'
    qui gen signy`i'=0 in `dateme'/`endme'
    qui gen signyl`i'=0 in `dateme'/`endme'
    qui gen signf`i'=0 in `dateme'/`endme'
    qui gen signfl`i'=0 in `dateme'/`endme'
    qui gen error_a`i'=. in `dateme'/`endme'
    qui gen error_l`i'=. in `dateme'/`endme'
    qui gen error_rw`i'=. in `dateme'/`endme'
    qui gen arfor`i'=. in `dateme'/`endme'
    qui gen rwfor`i'=. in `dateme'/`endme'
    qui gen actual`i'=. in `dateme'/`endme'
  }
  // Calculate forecasts
  while  `start0'<`end' {
    // Real time data for forecasting
	qui gen r`var'_last= ld_`mm'_`aa'
    qui gen r`var'_rt= ave_`mm'_`aa'
	// Target
	qui gen r`var'= tar_`aa'
    qui gen r`var'_lastday= tar_ld_`aa'
	// Model Data
	if `last'==1 { 
	  qui gen dlr`var'=r`var'_last in 1/`start0'
    } 
	else if `last'==0 {
	  qui gen dlr`var'=r`var'_rt in 1/`start0'
    } 
	
	*summarize dlrjpn
	*varsoc dlrjpn, maxlag(24)
	
	// Auto ARIMA 1 ***you will need Stata 18***
	*arimasoc rjpn_rt, maxar(12) maxma(0) arimaopts(iterate(20))

	// arimaauto - USER
	*arimaauto rjpn_rt, max(12 0) stat noseas nostep iterate(20) 
	
    // Recursive dynamic of ARIAM(p,1,w) 
	if `q'==1 { 
		qui arima dlr`var' in 1/`start0', ma(1/`q') ar(1/`p') from(armab0) 
		qui predict f_dlr`var', dynamic(`startd') 
    } 
	else if `q'==0 {
		qui regress dlr`var' l(1/`p').dlr`var' in 1/`start0'
		qui estimates store yhat
		qui forecast create omodel, replace
		qui forecast estimates yhat
		qui forecast solve, prefix(f_) begin(`startd') periods(65) 
    } 
	else if `q'==100 { 
		qui arimaauto dlr`var' in 1/`start0', max(12 0) stat noseas nostep iterate(20) 
		*qui arimasoc dlr`var' in 1/`start0', maxar(12) maxma(0) arimaopts(iterate(20))
		qui predict f_dlr`var', dynamic(`startd') 
    } 

    qui gen r`var'_f = f_dlr`var'
    // Real time no-change 
    qui gen r`var'_rw = r`var'_rt[`start0']
    qui gen r`var'_ld = r`var'_last[`start0']
    // Save statistics
    foreach i of numlist 1 3 6 12 24 36  {
      local sdate = `start0'+`i'
      // Model forecast
      qui replace arfor`i'=r`var'_f in `sdate'/`sdate'
      // Random walk forecast
      qui replace rwfor`i'=r`var'_rw in `sdate'/`sdate'
      // Actual
      qui replace actual`i'=r`var' in `sdate'/`sdate' 
      // Error
      qui replace error_a`i'=r`var'-r`var'_f in `sdate'/`sdate'
       // last day
      qui replace error_l`i'=r`var'-r`var'_ld in `sdate'/`sdate'
      // Random walk
      qui replace error_rw`i'=r`var'-r`var'_rw in `sdate'/`sdate'
      // Calc Success Ratios
      qui replace sign`i'=1 if r`var' - l`i'.r`var' >0 & r`var'_f - l`i'.r`var'_rt >0 in `sdate'/`sdate'
      qui replace sign`i'=1 if r`var' - l`i'.r`var' <0 & r`var'_f - l`i'.r`var'_rt <0 in `sdate'/`sdate'
      qui replace signl`i'=1 if r`var' - l`i'.r`var'_lastday >0 & r`var'_f - l`i'.r`var'_last >0 in `sdate'/`sdate'
      qui replace signl`i'=1 if r`var' - l`i'.r`var'_lastday <0 & r`var'_f - l`i'.r`var'_last <0 in `sdate'/`sdate'
      qui replace signy`i'=1 if r`var' - l`i'.r`var' >0 in `sdate'/`sdate'
      qui replace signyl`i'=1 if r`var' - l`i'.r`var'_lastday >0 in `sdate'/`sdate'
      qui replace signf`i'=1 if r`var'_f - l`i'.r`var'_rt >0 in `sdate'/`sdate'
      qui replace signfl`i'=1 if r`var'_f - l`i'.r`var'_last >0 in `sdate'/`sdate'
    }
    // Drop Variables
    drop r`var'_f f_dlr`var' r`var'_rw r`var'_rt r`var'_last r`var'_ld dlr`var' r`var' r`var'_lastday
	qui estimates clear
    *qui forecast drop
    // Update step by one period
    local start0=`start0'+1
    local startd=`startd'+1
    // Update real time data by one period
    if `mm'<12 { 
      local mm=`mm'+1 
    } 
    else if `mm'==12 { 
      local mm=1 
      local aa=`aa'+1 
    }
  } // date
  qui drop if _n>`end'
  foreach i of numlist 1 3 6 12 24 36   {
    qui gen error_asq`i' = error_a`i'^2
    qui gen error_lsq`i' = error_l`i'^2
    qui gen error_rwsq`i' = error_rw`i'^2
  } // h
  // AFTER THE MODEL FORECAST SUMMARIZE CRITERION
  // Ratio of MSPE of VAR to Random Walk 
    foreach i of numlist 1 3 6 12 24 36  {
	    qui summarize error_asq`i' 
        qui scalar mspet_ar`i' = r(mean)
	    qui summarize error_lsq`i' 
        qui scalar mspet_ld`i' = r(mean)
        qui summarize error_rwsq`i' 
        qui scalar mspet_rw`i' = r(mean)
	    qui scalar obs`i' = r(N)
        local nlags = round(4*(obs`i'/100)^(2/9))
	    //Diebold-Mariano Test following Killian et al
        capture drop dif
        qui gen dif=error_rwsq`i'-error_asq`i'
        qui newey dif, lag(`nlags')
        matrix M=r(table)
        scalar beta= M[1,1]
	    scalar nwerr= M[2,1]
	    scalar teststat=beta/nwerr
	    scalar pt`i'=1-normal(teststat)
        matrix drop M
	    //Last day
        capture drop difl
        qui gen difl=error_lsq`i'-error_asq`i' 
        qui newey difl, lag(`nlags')
        matrix M=r(table)
        scalar beta= M[1,1]
	    scalar nwerr= M[2,1]
	    scalar teststat=beta/nwerr
	    scalar pt_l`i'=1-normal(teststat)
        matrix drop M
      } // h
    
  //Success Ratios
  foreach i of numlist 1 3 6 12 24 36  {
  	//Success Ratios Using Pesaran Timmermann 2009 vs AVE
	qui summarize sign`i' 
	qui scalar phat`i' = r(mean)
	qui scalar obs`i' = r(N)
    local nlags = round(4*(obs`i'/100)^(2/9))
	qui newey signy`i' signf`i' , lag(`nlags')
    matrix M=r(table)
	scalar beta= M[1,1]
	scalar nwerr= M[2,1]
	scalar teststat=beta/nwerr
	scalar ptsr`i'=1-normal(teststat)
    matrix drop M
	//Success Ratios Using Pesaran Timmermann 2009 vs LD
	qui summarize signl`i' 
	qui scalar phat_l`i' = r(mean)
	qui scalar obs`i' = r(N)
    local nlags = round(4*(obs`i'/100)^(2/9))
	qui newey signyl`i' signfl`i' , lag(`nlags')
    matrix M=r(table)
	scalar beta= M[1,1]
	scalar nwerr= M[2,1]
	scalar teststat=beta/nwerr
	scalar ptsr_l`i'=1-normal(teststat)
    matrix drop M
    }

  putexcel A`pp'= " `var' "
  quietly {  
  log using logfile, append
  noisily: display "    "
 
  noisily: display "`var': PEPS==`last' & ARIMA(`p',0,`q') Levels" 
  
  noisily: display " vs AVE"
  // DISPLAY FINAL OBS MSPE AND P-VALUES
  foreach i of numlist 1 3 6 12 24 36  {
    capture drop dif difl
    drop error_a`i' error_l`i' error_rw`i' error_asq`i' error_lsq`i' error_rwsq`i' arfor`i' rwfor`i' actual`i'
    noisily: display "MSPE`i' vsAVE" _s(1) round(mspet_ar`i'/mspet_rw`i',.001) _s(1) round(pt`i',.001) 
    scalar amsperat`i'=round(mspet_ar`i'/mspet_rw`i',.001)   
    scalar apmsperat`i'=round(pt`i',.001)    
  }
  
    // DISPLAY FINAL OBS SR AND P-VALUES
  foreach i of numlist 1 3 6 12 24 36  {
    drop signy`i' signyl`i' signl`i' signf`i' signfl`i'  sign`i'
    noisily: display "SR`i' vsAVE" _s(1) round(phat`i',.001) _s(1) round(ptsr`i',.001)
	scalar aprat`i'=round(phat`i',.001)
	scalar apprat`i'=round(ptsr`i',.001)
  }   

  noisily: display " vs LD"
  foreach i of numlist 1 3 6 12 24 36  {
     noisily: display "MSPE`i' vsLD" _s(1) round(mspet_ar`i'/mspet_ld`i',.001) _s(1) round(pt_l`i',.001)
    scalar msperat`i'=round(mspet_ar`i'/mspet_ld`i',.001)   
    scalar pmsperat`i'=round(pt_l`i',.001)    
  }

  foreach i of numlist 1 3 6 12 24 36  {
    noisily: display "SR`i' vsLD" _s(1) round(phat_l`i',.001) _s(1) round(ptsr_l`i',.001) 
	scalar prat`i'=round(phat_l`i',.001)
	scalar pprat`i'=round(ptsr_l`i',.001)
  } 
  
  log close

  }
  putexcel B`pp'=msperat1
  putexcel C`pp'=msperat3
  putexcel D`pp'=msperat6
  putexcel E`pp'=msperat12
  putexcel F`pp'=msperat24
  putexcel G`pp'=msperat36
  putexcel H`pp'=prat1
  putexcel I`pp'=prat3
  putexcel J`pp'=prat6
  putexcel K`pp'=prat12
  putexcel L`pp'=prat24
  putexcel M`pp'=prat36
  putexcel N`pp'=pmsperat1
  putexcel O`pp'=pmsperat3
  putexcel P`pp'=pmsperat6
  putexcel Q`pp'=pmsperat12
  putexcel R`pp'=pmsperat24
  putexcel S`pp'=pmsperat36
  putexcel T`pp'=pprat1
  putexcel U`pp'=pprat3
  putexcel V`pp'=pprat6
  putexcel W`pp'=pprat12
  putexcel X`pp'=pprat24
  putexcel Y`pp'=pprat36

  putexcel AB`pp'=amsperat1
  putexcel AC`pp'=amsperat3
  putexcel AD`pp'=amsperat6
  putexcel AE`pp'=amsperat12
  putexcel AF`pp'=amsperat24
  putexcel AG`pp'=amsperat36
  putexcel AH`pp'=aprat1
  putexcel AI`pp'=aprat3
  putexcel AJ`pp'=aprat6
  putexcel AK`pp'=aprat12
  putexcel AL`pp'=aprat24
  putexcel AM`pp'=aprat36
  putexcel AN`pp'=apmsperat1
  putexcel AO`pp'=apmsperat3
  putexcel AP`pp'=apmsperat6
  putexcel AQ`pp'=apmsperat12
  putexcel AR`pp'=apmsperat24
  putexcel AS`pp'=apmsperat36
  putexcel AT`pp'=apprat1
  putexcel AU`pp'=apprat3
  putexcel AV`pp'=apprat6
  putexcel AW`pp'=apprat12
  putexcel AX`pp'=apprat24
  putexcel AY`pp'=apprat36



  clear all 
// ***************************
// Close and save log file
