trim_partial_month <- function(daily_zoo) {
  # If the daily observations at the end don't form a complete month, trim them
  last_day_with_data <- last(index(daily_zoo))
  end_of_last_month <- ceiling_date(as.Date(last(as.yearmon(index(daily_zoo)))), unit = "months") - 1
  if(last_day_with_data != end_of_last_month) {
    daily_zoo <- window(daily_zoo, start = NULL, end = floor_date(end_of_last_month, unit = "months")-1)
  }
  
  # If the daily observations at the start don't form a complete month, trim them
  first_day_with_data <- first(index(daily_zoo))
  first_day_of_first_month <- floor_date(as.Date(first(as.yearmon(index(daily_zoo)))), unit = "months")
  if(first_day_with_data != first_day_of_first_month) {
    daily_zoo <- window(daily_zoo, start = ceiling_date(first_day_of_first_month, unit = "months"), end = NULL)
  }
  return(daily_zoo)
}

trim_partial_quarter <- function(daily_zoo) {
  # If the daily observations at the end don't form a complete month, trim them
  last_day_with_data <- last(index(daily_zoo))
  end_of_last_quarter <- ceiling_date(as.Date(last(as.yearqtr(index(daily_zoo)))), unit = "quarters") - 1
  if(last_day_with_data != end_of_last_quarter) {
    daily_zoo <- window(daily_zoo, start = NULL, end = floor_date(end_of_last_quarter, unit = "quarters")-1)
  }
  
  # If the daily observations at the start don't form a complete month, trim them
  first_day_with_data <- first(index(daily_zoo))
  first_day_of_first_quarter <- floor_date(as.Date(first(as.yearqtr(index(daily_zoo)))), unit = "quarters")
  if(first_day_with_data != first_day_of_first_quarter) {
    daily_zoo <- window(daily_zoo, start = ceiling_date(first_day_of_first_quarter, unit = "quarters"), end = NULL)
  }
  return(daily_zoo)
}