##################################### CONVERT ZOO TO TIME SERIES ############################################

# Convert a zoo object to a time series object
# This is useful because input_vintage is a zoo object, but some forecasting methods expect time series objects
convert_zoo_to_ts <- function(z) {
  if(class(index(z))=="yearqtr") {
    ts(data = z, start = as.numeric(as.yearqtr(first(index(z)))), frequency = 4)
  } else if(class(index(z))=="yearmon") {
    ts(data = z, start = as.numeric(as.yearmon(first(index(z)))), frequency = 12)
  } else if (class(index(z))=="Date") {
    ts(data = z, start = as.numeric(as.Date(first(index(z)))), frequency = 1)
  }
}