
################################## MISCELLANEOUS FUNCTIONS ##############################################

# Round a date to the closest date that is at the end of a month
round_to_nearest_end_of_month <- function(date) {
  end_of_month_dates <- seq.Date(from = as.Date(paste0(year(date)-2, "-12-31")), to = as.Date(paste0(year(date)+2, "-12-31")), by = "month")
  deviations <- date - end_of_month_dates
  end_of_month_dates[which.min(abs(deviations))]
}

########################## FUNCTIONS FOR VINTAGE NAMES ################################################

# This function converts a yearmon, like "Apr 2021", to a character like "apr2021"
as.vintage_name <- function(vintage_yearmon) {gsub(" ", "", tolower(as.character(vintage_yearmon)))}

### ARGUMENT
# vintage_name, which must be coercible to yearmon with exactly one element
# vintage_name_vector, which must be coercible to yearmon with any number of elements

## VALUE
# The entry of vintage_name_vector that is closest to vintage_name, converted into the format used to refer to WEO vintages
find_closest_vintage_name <- function(vintage_name, vintage_name_vector) {
  # Look for an exact match
  if(any(as.yearmon(vintage_name) == as.yearmon(vintage_name_vector))) {return(as.vintage_name(vintage_name))}
  
  # If there is no match, find the closest vintage
  # https://stackoverflow.com/questions/14968954/return-index-from-a-vector-of-the-value-closest-to-a-given-element
  as.vintage_name(vintage_name_vector[which.min(abs(as.yearmon(vintage_name) - as.yearmon(vintage_name_vector)))])
}

############ FUNCTIONS FOR CHANGING MONTHLY OR QUARTERLY INDEX TO DATE INDEX ##############################################

# Changes the index of a zoo object to the last day of a month, quarter or year
swap_yearmon_to_date <- function(yearmon_zoo) {
  index(yearmon_zoo) <- do.call(c, map(index(yearmon_zoo), function(yearmon) (as.Date(yearmon) + months(1) - days(1))))
  return(yearmon_zoo)
}
swap_yearqtr_to_date <- function(yearqtr_zoo) {
  index(yearqtr_zoo) <- do.call(c, map(index(yearqtr_zoo), function(yearqtr) (as.Date(yearqtr) + months(3) - days(1))))
  return(yearqtr_zoo)
}
swap_period_to_end_date_univariate <- function(z) {
  is.wholenumber <- function(x)  {all(abs(x - round(x)) < .Machine$double.eps^0.5)}
  if(is.wholenumber(index(z))) {
    stop("To convert calendar years to dates, use 'swap_year_to_date' in 'FY_helper_functions.R'")
  } else if (class(index(z)) == "yearqtr") {
    return(swap_yearqtr_to_date(z))
  } else if (class(index(z)) == "yearmon") {
    return(swap_yearmon_to_date(z))
  } else {
    stop("swap_period_to_end_date only supports yearqtr and yearmon indexes at present")
  }
}
swap_period_to_end_date <- function(z_list) {map(z_list, swap_period_to_end_date_univariate)}