rm(list = ls())

library(tidyverse)
library(zoo)

compute_rer_for_vintage <- function(vintage_name, ner_directory, cpi_directory, rer_directory) {
  # Import data for chosen vintage
  ner_country <- readRDS(paste0(ner_directory, vintage_name, ".rds"))
  cpi_country <- readRDS(paste0(cpi_directory, vintage_name, ".rds"))
  country_names <- intersect(names(ner_country), names(cpi_country))
  
  # Compute Relative Price Indexes of each country compared to the US
  rpi_country <- map(country_names, function(x) cpi_country[[x]]/cpi_country[["United States"]])
  names(rpi_country) <- country_names
  
  # Compute the RER of each country
  rer_country <- map(country_names, function(x) ner_country[[x]]*rpi_country[[x]])
  names(rer_country) <- country_names
  
  saveRDS(rer_country, paste0(rer_directory, vintage_name, ".rds"))
}
compute_rer <- function(ner_directory, cpi_directory, rer_directory) {
  vintage_names <- sort(as.yearmon(intersect(gsub(".rds", "", list.files(ner_directory)), gsub(".rds", "", list.files(cpi_directory)))))
  walk(vintage_names,
       compute_rer_for_vintage,
       ner_directory = ner_directory, cpi_directory = cpi_directory, rer_directory = rer_directory)
}

# Compute month-average RER
compute_rer(ner_directory = "Mid_data/FX/Bilateral_NER/RDS_by_vintage/Month_avg_Bilateral_NER/",
            cpi_directory = "Mid_data/FX/CPI/Monthly_CPI/cpi_m_extra/",
            rer_directory = "Mid_data/FX/Bilateral_RER/RDS_by_vintage/Month_avg_Bilateral_RER/")

# Compute month-end RER
compute_rer(ner_directory = "Mid_data/FX/Bilateral_NER/RDS_by_vintage/Month_end_Bilateral_NER/",
            cpi_directory = "Mid_data/FX/CPI/Monthly_CPI/cpi_m_extra/",
            rer_directory = "Mid_data/FX/Bilateral_RER/RDS_by_vintage/Month_end_Bilateral_RER/")

# Compute daily RER with step interpolated CPI
compute_rer(ner_directory = "Mid_data/FX/Bilateral_NER/RDS_by_vintage/Daily_Bilateral_NER/",
            cpi_directory = "Mid_data/FX/CPI/Daily_CPI/cpi_eom_to_d_Step/",
            rer_directory = "Mid_data/FX/Bilateral_RER/RDS_by_vintage/Daily_Bilateral_Step_RER/")

# Compute daily RER with linearly interpolated CPI
compute_rer(ner_directory = "Mid_data/FX/Bilateral_NER/RDS_by_vintage/Daily_Bilateral_NER/",
            cpi_directory = "Mid_data/FX/CPI/Daily_CPI/cpi_eom_to_d_Linear/",
            rer_directory = "Mid_data/FX/Bilateral_RER/RDS_by_vintage/Daily_Bilateral_Linear_RER/")
