
rm(list = ls())

library(zoo)
library(tidyverse)

source('Code/Tidy_fx_functions/multiply_ner_and_cpi.R')

##################################### IMPORT NER AND CPI #######################################################

# We want to compute monthly vintages of NER*CPI, where each vintage is based on data available at that month
# For each month T, we use:
# A CPI vintage that has CPI data up to month T
# The latest NER vintage, which has NER data up to end Sep 2022
# There is no need to use distinct NER vintages, because when you multiply NER up to Oct 2022 and CPI up to T,
# R will only compute the multiplied series for months up to T anyway

# Import the latest vintage of NERs
ner_transformed <- readRDS("Mid_data/FX/Bilateral_NER/ner_transformed.rds")

# Import vintages of daily CPI
cpi_d_directory <- "Mid_data/FX/CPI/Daily_CPI/cpi_eom_to_d_Step/"

# Import vintages of monthly CPI
cpi_m_directory <- "Mid_data/FX/CPI/Monthly_CPI/cpi_m_extra/"

##################################### MULTIPLY EDNA AND CPIs #######################################################

# We make vintages from Jan 1995 (the month when the 1979-1989 weights become available, given a 5 year lag)
# to Sep 2022 (the last month where IMF has daily NERs for the whole month)
vintage_names <- as.character(seq(from = as.yearmon("Jan 1995"), to = as.yearmon("Sep 2022"), by = 1/12))

# Multiply daily NER and daily CPI
walk(vintage_names,
     multiply_ner_and_cpi_for_vintage,
     ner = ner_transformed$Daily, cpi_directory = cpi_d_directory, write_folder = "Daily_Bilateral_NER_Daily_Step_CPI")

# Multiply month-end NER and monthly CPI
walk(vintage_names,
     multiply_ner_and_cpi_for_vintage,
     ner = ner_transformed$Month_end, cpi_directory = cpi_m_directory, write_folder = "Month_end_Bilateral_NER_Monthly_CPI")

# Multiply month-average NER and monthly CPI
walk(vintage_names,
     multiply_ner_and_cpi_for_vintage,
     ner = ner_transformed$Month_avg, cpi_directory = cpi_m_directory, write_folder = "Month_avg_Bilateral_NER_Monthly_CPI")
