
rm(list = ls())

library(zoo)
library(lubridate)

source("Code/Tidy_functions/remove_null.R")

ner_transformed <- readRDS("Mid_data/FX/Bilateral_NER/ner_transformed.rds")

############################# CONSTRUCT VINTAGES OF NERs #################################

# For each transformation of NERs (daily, month-average, quarter-average, month-end, quarter-end),
# make a folder containing an RDS file for each vintage of NERs
construct_ner_vintage <- function(vintage_name, ner_country, directory, transformation_name) {
  if (transformation_name == "Daily") {
    last_day_of_month <- ceiling_date(as.Date(as.yearmon(vintage_name)), unit = "months") - 1
    window_ner <- map(ner_country, function(x) window(x, start = NULL, end = last_day_of_month))
  } else if (transformation_name == "Month_avg" || transformation_name == "Month_end") {
    window_ner <- map(ner_country, function(x) window(x, start = NULL, end = vintage_name))
  } else if (transformation_name == "Quarter_avg" || transformation_name == "Quarter_end") {
    if (months(vintage_name) %in% c(3, 6, 9, 12)) {last_complete_quarter <- as.yearqtr(vintage_name)} else {last_complete_quarter <- as.yearqtr(vintage_name) - 1/4}
    window_ner <- map(ner_country, function(x) window(x, start = NULL, end = last_complete_quarter))
  }
  saveRDS(remove_null(window_ner), paste0(directory, vintage_name, ".rds"))
}
construct_ner_vintages <- function(ner_country, transformation_name) {
  vintage_names <- sort(as.yearmon(Reduce(union, map(ner_country, function(x) unique(as.yearmon(index(x)))))))
  walk(vintage_names,
       construct_ner_vintage,
       ner_country = ner_country, directory = paste0("Mid_data/FX/Bilateral_NER/RDS_by_vintage/", transformation_name, "_Bilateral_NER/"), transformation_name = transformation_name)
}
walk2(ner_transformed[c("Daily", "Month_avg", "Month_end")], c("Daily", "Month_avg", "Month_end"), construct_ner_vintages)