
rm(list = ls())

library(tidyverse)
library(zoo)
library(openxlsx)
library(lubridate)

source('Code/Tidy_functions/transform_zoo_functions.R')
source('Code/Tidy_functions/change_nesting_order.R')
source('Code/Tidy_functions/retain_vintages_after_big_revision.R')

source('Code/Tidy_fx_functions/trim_partial_period.R')

source('Code/Interpolation_fx_functions/extrapolate_linearly_forward_back.R')
source('Code/Interpolation_fx_functions/interpolate_fx.R')

#################################### CONSTRUCT VINTAGES OF MONTHLY CPI ###################################

# Import the raw vintages of monthly CPI
cpi_m <- readRDS("Mid_data/FX/CPI/Monthly_CPI/cpi_m.rds")

# I convert levels to log levels, interpolate and extrapolate as needed, then convert back to levels
# This is because linear interpolation or extrapolation is more reasonable for a log level (where it implies constant inflation) than a level
map_log <- function(country_list) {map(country_list, log)}
cpi_m_log <- map(cpi_m, map_log)

### EXTRAPOLATE MONTHLY TO MONTH WHEN VINTAGE PUBLISHED

# Extrapolate log CPI
extrapolate_vintage <- function(country_list, vintage_name) {
  map(country_list, extrapolate_linearly_forward_back, first_period = NULL, last_period = vintage_name) %>%
    saveRDS(paste0("Mid_data/FX/CPI/Monthly_CPI/cpi_m_log_extra/", vintage_name, ".rds"))
}
walk2(cpi_m_log, as.yearmon(names(cpi_m_log)), extrapolate_vintage)

# Take exponent of log CPI
exponentiate_vintage <- function(vintage_name, read_directory, write_directory) {
  map(readRDS(paste0(read_directory, vintage_name, ".rds")), exp) %>%
    saveRDS(paste0(write_directory, vintage_name, ".rds"))
}
exponentiate_vintages <- function(read_directory, write_directory) {
  vintage_names <- gsub(".rds", "", list.files(read_directory))
  walk(vintage_names, exponentiate_vintage, read_directory = read_directory, write_directory = write_directory)
}
exponentiate_vintages(read_directory = "Mid_data/FX/CPI/Monthly_CPI/cpi_m_log_extra/",
                      write_directory = "Mid_data/FX/CPI/Monthly_CPI/cpi_m_extra/")

############################## CONSTRUCT VINTAGES OF DAILY CPI ###################################

# Compute daily log CPI
interpolate_vintages(read_directory = "Mid_data/FX/CPI/Monthly_CPI/cpi_m_log_extra/", method = "Step")
interpolate_vintages(read_directory = "Mid_data/FX/CPI/Monthly_CPI/cpi_m_log_extra/", method = "Linear")
interpolate_vintages(read_directory = "Mid_data/FX/CPI/Monthly_CPI/cpi_m_log_extra/", method = "Spline")

# Visualise interpolation process
visualise_interpolate_eom_to_d(vintage_name = "Sep 2022", country_name = "Japan", method = "Step", cpi_m = cpi_m)
visualise_interpolate_eom_to_d(vintage_name = "Sep 2022", country_name = "Japan", method = "Linear", cpi_m = cpi_m)
visualise_interpolate_eom_to_d(vintage_name = "Sep 2022", country_name = "Japan", method = "Spline", cpi_m = cpi_m)

# Take exponent of log CPI
exponentiate_vintages(read_directory = "Mid_data/FX/CPI/Daily_CPI/cpi_eom_to_d_log_Step/",
                      write_directory = "Mid_data/FX/CPI/Daily_CPI/cpi_eom_to_d_Step/")