
### Make iso_one and iso_three use the country names in country_facts, which ensures I can link ISO data to other datasets
fix_country_name <- function(x) {
  # If there are brackets, extract the parts before and after the brackets only
  # However, just before doing this, deal with the two Congos, as losing the terms in brackets
  # will make them appear the same
  if(x == "Congo (The Democratic Republic Of The)") {x <-  "Congo, Democratic Republic Of The"}
  if(x == "Congo (The)" ) {x <-  "Congo, Republic of"}
  if(grepl("\\(", x) & grepl("\\)", x)) {
    before <- substr(x, start = 1, stop = (regexec("\\(", x)[[1]][1] - 2))
    after <- substr(x, start = (regexec("\\)", x)[[1]][1] + 1), stop = nchar(x))
    x <- paste0(before, after)
  }
  
  # Manually handle any differences that arise in country 
  case_when(
    x == "Bahamas" ~ "Bahamas, The",
    x == "Burma " ~ "Myanmar", # The 'dot' is part of the character string in the iso_three spreadsheet
    x == "Czechia" ~ "Czech Republic",
    x == "Gambia" ~ "Gambia, The",
    x == "Kyrgyzstan" ~ "Kyrgyz Republic",
    x == "Hong Kong" ~ "Hong Kong SAR",
    x == "Lao" ~ "Lao P.D.R.",
    x == "Lao People’s Democratic Republic" ~ "Lao P.D.R.",
    x == "Macao" ~ "Macao SAR",
    x == "Moldova, Republic Of" ~ "Moldova",
    x == "Montenegro" ~ "Montenegro, Rep. Of",
    x == "Russian Federation" ~ "Russia",
    x == "Sao Tome And Principe" ~ "São Tomé And Príncipe",
    x == "Slovakia" ~ "Slovak Republic",
    x == "Swaziland" ~ "Eswatini",
    x == "Syrian Arab Republic" ~ "Syria",
    x == "Taiwan" ~ "Taiwan Province of China",
    x == "Tanzania, United Republic Of" ~ "Tanzania",
    x == "Türki̇ye" ~ "Turkey",
    x == "United Kingdom Of Great Britain And Northern Ireland" ~ "United Kingdom",
    x == "United States Of America" ~ "United States",
    x == "Viet Nam" ~ "Vietnam",
    x == "Yemen, Democratic" ~ "Yemen",
    TRUE ~ x
  )
}

### Make iso_one and iso_three use the currency names in EAER_currency, which tend to be more descriptive
fix_currency_name <- function(x, y) {
  # Correct the names of currencies shared by multiple countries
  if(y == "East Caribbean Dollar") {return("Eastern Caribbean Dollar")}
  
  # Correct the names of currencies used by one country
  # Sometimes this just requires pasting the names
  if((x == "Bangladesh" & y == "Taka") | (x == "Botswana" & y == "Pula") | (x == "Kyrgyz" & y == "Som") | (x == "Lesotho" & y == "Loti")
     | (x == "Papua New Guinea" & y == "Kina") | (x == "Myanmar" & y == "Kyat") | (x == "Samoa" & y == "Tala") | (x == "Vanuatu" & y == "Vatu")) {return(paste(x, y))}
  
  # Other times we need to manually specify the currency name
  if(x == "Bahrain" & y == "Bahraini Dinar") {return("Bahrain Dinar")}
  if(x == "Belarus" & y == "Belarusian Ruble") {return("Belarussian Rubel")}
  if(x == "Bhutan" & y == "Ngultrum") {return("Bhutanese Ngultrum")}
  if(x == "Cabo Verde" & y == "Cabo Verde Escudo") {return("Cape Verde Escudo")}
  if(x == "Cambodia" & y == "Riel") {return("Cambodian Riel")}
  if(x == "China" & y == "Yuan Renminbi") {return("Chinese Renminbi")}
  if(x ==  "Congo, Democratic Republic Of The" & y == "Congolese Franc") {return("Congo Franc")}
  if(x == "Comoros" & y == "Comorian Franc ") {return("Comorian Franc")}
  if(x == "Costa Rica" & y == "Costa Rican Colon") {return("Costa Rican Colón")}
  if(x == "El Salvador" & y == "El Salvador Colon") {return("Salvadoran Colón")}
  if(x == "Eritrea" & y == "Nakfa") {return("Eritrean Nakfa")}
  if(x == "Estonia" & y == "Kroon") {return("Estonian Kroon")}
  if(x == "Eswatini" & y == "Lilangeni") {return("Swaziland Lilangeni")}
  if(x == "Gambia, The" & y == "Dalasi") {return("Gambian Dalasi")}
  if(x == "Georgia" & y == "Lari") {return("Georgian Lari")}
  if(x == "Ghana" & y == "Ghana Cedi") {return("Ghanaian Cedi")}
  if(x == "Greece" & y == "Drachma") {return("Greek Drachma")}
  if(x == "Guatemala" & y == "Quetzal") {return("Guatemalan Quetzal")}
  if(x == "Haiti" & y == "Gourde") {return("Haitian Gourde")}
  if(x == "Honduras" & y == "Lempira") {return("Honduran Lempira")}
  if(x == "Hungary" & y == "Forint") {return("Hungarian Forint")}
  if(x == "Iceland" & y == "Iceland Krona") {return("Icelandic Króna")}
  if(x == "Indonesia" & y == "Rupiah") {return("Indonesian Rupiah")}
  if(x == "Israel" & y == "New Israeli Sheqel") {return("Israeli New Sheqel")}
  if(x == "Jamaica" & y == "Jamaican Dollar") {return("Jamaica Dollar")}
  if(x == "Japan" & y == "Yen") {return("Japanese Yen")}
  if(x == "Jordan" & y == "Jordanian Dinar") {return("Jordan Dinar")}
  if(x == "Kazakhstan" & y == "Tenge") {return("Kazakh Tenge")}
  if(x == "Kenya" & y == "Kenyan Shilling") {return("Kenya Shilling")}
  if(x == "Korea" & y == "Won") {return("Korean Won")}
  if(x == "Maldives" & y == "Rufiyaa") {return("Maldivian Rufiyaa")}
  if(x == "Mauritania" & y == "Ouguiya") {return("Mauritanian Ouguiya")}
  if(x == "Mauritius" & y == "Mauritius Rupee") {return("Mauritian Rupee")}
  if(x == "Mongolia" & y == "Tugrik") {return("Mongolian Togrog")}
  if(x == "Mozambique" & y == "Mozambique Metical") {return("Mozambican Meti")}
  if(x == "Nigeria" & y == "Naira") {return("Nigerian Naira")}
  if(x == "North Macedonia" & y == "Denar") {return("Macedonian Denar")}
  if(x == "Nicaragua" & y == "Cordoba Oro") {return("Nicaraguan Córdoba")}
  if(x == "Panama" & y == "Balboa") {return("Panamanian Balboa")}
  if(x == "Paraguay" & y == "Guarani") {return("Paraguayan Guaraní")}
  if(x == "Poland" & y == "Zloty") {return("Polish Zloty")}
  if(x == "Peru" & y == "Sol") {return("Peruvian Nuevo Sol")}
  if(x == "Qatar" & y == "Qatari Rial") {return("Qatar Riyal")}
  if(x == "São Tomé And Príncipe" & y == "Dobra") {return("São Tomé And Príncipe Dobra")}
  if(x == "Saudi Arabia" & y == "Saudi Riyal") {return("Saudi Arabian Riyal")}  
  if(x == "Sierra Leone" & y == "Leone") {return("Sierra Leonean Leone")}
  if(x == "Slovenia" & y == "Tolar") {return("Slovenian Tolar")}
  if(x == "South Africa" & y == "Rand") {return("South African Rand")}
  if(x == "Suriname" & y == "Surinam Guilder") {return("Suriname Guilder")}
  if(x == "Thailand" & y == "Baht") {return("Thai Baht")}  
  if(x == "Tonga" & y == "Pa’anga") {return("Tongan Paʹanga")}
  if(x == "Turkmenistan" & y == "Turkmenistan Manat") {return("Turkmen Manat")}
  if(x == "Venezuela" & y == "Bolivar") {return("Venezuelan Bolívar")}
  return(y)
}

### Make the withdrawal dates more precise

# The withdrawal dates are vague, so I make them precise
# I will abstain from splicing IMF and Eikon data where a currency was discontinued before the earliest IMF data,
# so to be conservative I err on assuming the withdrawal dates were at the earliest time within any range
convert_chr_to_date <- function(x) {as.Date(paste0(substr(x, start = 1, stop = 4), "-", substr(x, start = 6, stop = 7), "-", 1))}
convert_Withdrawal.Date <- function(Withdrawal.Date) {
  # If the withdrawal date is a range, assume the currency was withdrawn on the first day of the earlier period
  if(grepl(" to ", Withdrawal.Date)) {
    earlier_period <- substr(Withdrawal.Date, start = 1, stop = (regexec(pattern = " to ", Withdrawal.Date)[[1]][1]-1))
    if(nchar(earlier_period)==7) {return(convert_chr_to_date(Withdrawal.Date))}
    if(nchar(earlier_period)==4) {return(as.Date(paste0(earlier_period, "-01-01")))}
  }
  
  # I need to handle one special case, which is that Vietnam's Withdrawal.Date is given as a range without a 'to'.
  if(Withdrawal.Date == "1989-1990") {return(as.Date("1989-01-01"))}
  
  # If the withdrawal date is a yearmon stored as a character, convert it to a yearmon
  return(convert_chr_to_date(Withdrawal.Date))
}

### Perform all tidying steps
tidy_iso_one <- function(iso_one) {
  iso_one$ENTITY <- unlist(map(str_to_title(iso_one$ENTITY), fix_country_name))
  iso_one$Currency <- unlist(map2(iso_one$ENTITY, str_to_title(iso_one$Currency), fix_currency_name))
  return(iso_one)
}

tidy_iso_three <- function(iso_three) {
  iso_three$Withdrawal.Date <- do.call(c, map(iso_three$Withdrawal.Date, convert_Withdrawal.Date))
  iso_three$ENTITY <- unlist(map(str_to_title(iso_three$ENTITY), fix_country_name))
  iso_three$Historic.currency <- unlist(map2(iso_three$ENTITY, str_to_title(iso_three$Historic.currency), fix_currency_name))
  return(iso_three)
}

