// -----------------------------	
// Stephen Snudden August 2024
// -----------------------------	

//*********
//Intro formalities

args var starty mms endy mme pp

*local var ="usa"
*local starty = 2004
*local mms =1
*local endy =2022
*local mme =1
*local pp =3

clear all
capture drop _all
set more off

//***************************

  use DataM
  tsappend, add(70)
  set more off

  // Set dates. 
  local mm=`mms' // month to start
  local aa=`starty' // year to start
  local startdate = "`aa'm`mm'"
  local enddate = "`endy'm`mme'" // year and month to end
  
  //Note: In Stata default for time is 0 at 1960m1: see tsset.  Need to adjust (adj) 
  local adj = time[_n==1]-1
  local start = tm(`startdate')-`adj'
  local start0=`start'
  local startd=tm(`startdate')+1 // Set one step ahead
  local end=tm(`enddate')-`adj'+1 // last forecast date
  
  // Construct series
  foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 24 36{
    local dateme = `start0'+`i'
    local datemet = `start0'+30
    local endme = `end'+`i'-1
    local endmet = `end'-`i'-1
    qui gen sign`i'=0 in `dateme'/`endme'
    qui gen signl`i'=0 in `dateme'/`endme'
    qui gen signy`i'=0 in `dateme'/`endme'
    qui gen signyl`i'=0 in `dateme'/`endme'
    qui gen signf`i'=0 in `dateme'/`endme'
    qui gen signfl`i'=0 in `dateme'/`endme'

    qui gen error_l`i'=. in `dateme'/`endme'
    qui gen error_rw`i'=. in `dateme'/`endme'

    qui gen rwfor`i'=. in `dateme'/`endme'
    qui gen actual`i'=. in `dateme'/`endme'
  }
  // Calculate forecasts
  while  `start0'<`end' {
    // Real time data for forecasting
    qui gen r`var'_last= ld_`mm'_`aa'
    qui gen r`var'_rt= ave_`mm'_`aa'
    // Target
    qui gen r`var'= tar_`aa'
    qui gen r`var'_lastday= tar_ld_`aa'

    // Real time no-change 
    qui gen r`var'_rw = r`var'_rt[`start0']
    qui gen r`var'_ld = r`var'_last[`start0']
    // Save statistics
    foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 24 36  {
      local sdate = `start0'+`i'

      // Random walk forecast
      qui replace rwfor`i'=r`var'_rw in `sdate'/`sdate'
      // Actual
      qui replace actual`i'=r`var' in `sdate'/`sdate' 

       // last day
      qui replace error_l`i'=r`var'-r`var'_ld in `sdate'/`sdate'
      // Random walk
      qui replace error_rw`i'=r`var'-r`var'_rw in `sdate'/`sdate'
      // Calc Success Ratios
      qui replace sign`i'=1 if r`var' - l`i'.r`var' >0 & r`var'_ld - l`i'.r`var'_rt >0 in `sdate'/`sdate'
      qui replace sign`i'=1 if r`var' - l`i'.r`var' <0 & r`var'_ld - l`i'.r`var'_rt <0 in `sdate'/`sdate'
      qui replace signl`i'=1 if r`var' - l`i'.r`var'_lastday >0 & r`var'_rw - l`i'.r`var'_last >0 in `sdate'/`sdate'
      qui replace signl`i'=1 if r`var' - l`i'.r`var'_lastday <0 & r`var'_rw - l`i'.r`var'_last <0 in `sdate'/`sdate'
      qui replace signy`i'=1 if r`var' - l`i'.r`var' >0 in `sdate'/`sdate'
      qui replace signyl`i'=1 if r`var' - l`i'.r`var'_lastday >0 in `sdate'/`sdate'
      qui replace signf`i'=1 if r`var'_ld - l`i'.r`var'_rt >0 in `sdate'/`sdate'
      qui replace signfl`i'=1 if r`var'_rw - l`i'.r`var'_last >0 in `sdate'/`sdate'
    }
    // Drop Variables
    drop r`var'_rw r`var'_rt r`var'_last r`var'_ld r`var' r`var'_lastday
	qui estimates clear
    *qui forecast drop
    // Update step by one period
    local start0=`start0'+1
    local startd=`startd'+1
    // Update real time data by one period
    if `mm'<12 { 
      local mm=`mm'+1 
    } 
    else if `mm'==12 { 
      local mm=1 
      local aa=`aa'+1 
    }
  } // date
  qui drop if _n>`end'
  foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 24 36   {

    qui gen error_lsq`i' = error_l`i'^2
    qui gen error_rwsq`i' = error_rw`i'^2
  } // h
  // AFTER THE MODEL FORECAST SUMMARIZE CRITERION
  // Ratio of MSPE of VAR to Random Walk 
    foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 24 36  {

	qui summarize error_lsq`i' 
        qui scalar mspet_ld`i' = r(mean)
        qui summarize error_rwsq`i' 
        qui scalar mspet_rw`i' = r(mean)
	qui scalar obs`i' = r(N)
        local nlags = round(4*(obs`i'/100)^(2/9))
	//Diebold-Mariano Test following Killian et al
        capture drop dif
        qui gen dif=error_rwsq`i'-error_lsq`i'
        qui newey dif, lag(`nlags')
        matrix M=r(table)
        scalar beta= M[1,1]
	scalar nwerr= M[2,1]
	scalar teststat=beta/nwerr
	scalar pt`i'=1-normal(teststat)
        matrix drop M
        //Last day
        capture drop difl
        qui gen difl=error_lsq`i'-error_rwsq`i' 
        qui newey difl, lag(`nlags')
        matrix M=r(table)
        scalar beta= M[1,1]
	scalar nwerr= M[2,1]
	scalar teststat=beta/nwerr
	scalar pt_l`i'=1-normal(teststat)
        matrix drop M
      } // h
    
  //Success Ratios
  foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 24 36  {
  	//Success Ratios Using Pesaran Timmermann 2009 vs AVE
	qui summarize sign`i' 
	qui scalar phat`i' = r(mean)
	qui scalar obs`i' = r(N)
    local nlags = round(4*(obs`i'/100)^(2/9))
	qui newey signy`i' signf`i' , lag(`nlags')
    matrix M=r(table)
	scalar beta= M[1,1]
	scalar nwerr= M[2,1]
	scalar teststat=beta/nwerr
	scalar ptsr`i'=1-normal(teststat)
    matrix drop M
	//Success Ratios Using Pesaran Timmermann 2009 vs LD
	qui summarize signl`i' 
	qui scalar phat_l`i' = r(mean)
	qui scalar obs`i' = r(N)
    local nlags = round(4*(obs`i'/100)^(2/9))
	qui newey signyl`i' signfl`i' , lag(`nlags')
    matrix M=r(table)
	scalar beta= M[1,1]
	scalar nwerr= M[2,1]
	scalar teststat=beta/nwerr
	scalar ptsr_l`i'=1-normal(teststat)
    matrix drop M
    }

  putexcel A`pp'= " `var' "
  quietly {  
  log using logfile, append
  noisily: display "    "
  noisily: display "`var': Comparison of No-Change Forecasts" 
  noisily: display "vsAVE" 
     
  // DISPLAY FINAL OBS MSPE AND P-VALUES
  foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 24 36  {
    capture drop dif difl
    drop error_l`i' error_rw`i' error_lsq`i' error_rwsq`i' rwfor`i' actual`i'
    noisily: display "MSPE`i' vsAVE" _s(1) round(mspet_ld`i'/mspet_rw`i',.001) _s(1) round(pt`i',.001) 
    scalar amsperat`i'=round(mspet_ld`i'/mspet_rw`i',.001)   
    scalar apmsperat`i'=round(pt`i',.001)    
  }
  
  // DISPLAY FINAL OBS SR AND P-VALUES
  foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 24 36  {
    drop signy`i' signyl`i' signl`i' signf`i' signfl`i'  sign`i'
    noisily: display "SR`i' vsAVE" _s(1) round(phat`i',.001) _s(1) round(ptsr`i',.001)
	scalar aprat`i'=round(phat`i',.001)
	scalar apprat`i'=round(ptsr`i',.001)
  }   

  noisily: display "vsLD" 
  foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 24 36  {
	noisily: display "MSPE`i' vsLD" _s(1) round(mspet_rw`i'/mspet_ld`i',.001) _s(1) round(pt_l`i',.001)
    scalar msperat`i'=round(mspet_rw`i'/mspet_ld`i',.001)   
    scalar pmsperat`i'=round(pt_l`i',.001)    
  }
  
  foreach i of numlist 1 2 3 4 5 6 7 8 9 10 11 12 24 36  {
    noisily: display "SR`i' vsLD" _s(1) round(phat_l`i',.001) _s(1) round(ptsr_l`i',.001) 
	scalar prat`i'=round(phat_l`i',.001)
	scalar pprat`i'=round(ptsr_l`i',.001)
  } 
  log close

  }
  putexcel B`pp'=msperat1
  putexcel C`pp'=msperat2
  putexcel D`pp'=msperat3
  putexcel E`pp'=msperat4
  putexcel F`pp'=msperat5
  putexcel G`pp'=msperat6
  putexcel H`pp'=msperat7
  putexcel I`pp'=msperat8
  putexcel J`pp'=msperat9
  putexcel K`pp'=msperat10
  putexcel L`pp'=msperat11
  putexcel M`pp'=msperat12
  putexcel N`pp'=msperat24
  putexcel O`pp'=msperat36
  putexcel P`pp'=prat1
  putexcel Q`pp'=prat2
  putexcel R`pp'=prat3
  putexcel S`pp'=prat4
  putexcel T`pp'=prat5
  putexcel U`pp'=prat6
  putexcel V`pp'=prat7
  putexcel W`pp'=prat8
  putexcel X`pp'=prat9
  putexcel Y`pp'=prat10
  putexcel Z`pp'=prat11
  putexcel AA`pp'=prat12
  putexcel AB`pp'=prat24
  putexcel AC`pp'=prat36
  putexcel AD`pp'=pmsperat1
  putexcel AE`pp'=pmsperat2
  putexcel AF`pp'=pmsperat3
  putexcel AG`pp'=pmsperat4
  putexcel AH`pp'=pmsperat5
  putexcel AI`pp'=pmsperat6
  putexcel AJ`pp'=pmsperat7
  putexcel AK`pp'=pmsperat8
  putexcel AL`pp'=pmsperat9
  putexcel AM`pp'=pmsperat10
  putexcel AN`pp'=pmsperat11
  putexcel AO`pp'=pmsperat12
  putexcel AP`pp'=pmsperat24
  putexcel AQ`pp'=pmsperat36
  putexcel AR`pp'=pprat1
  putexcel AS`pp'=pprat2
  putexcel AT`pp'=pprat3
  putexcel AU`pp'=pprat4
  putexcel AV`pp'=pprat5
  putexcel AW`pp'=pprat6
  putexcel AX`pp'=pprat7
  putexcel AY`pp'=pprat8
  putexcel AZ`pp'=pprat9
  putexcel BA`pp'=pprat10
  putexcel BB`pp'=pprat11
  putexcel BC`pp'=pprat12
  putexcel BD`pp'=pprat24
  putexcel BE`pp'=pprat36
            
  putexcel BG`pp'=amsperat1
  putexcel BH`pp'=amsperat2
  putexcel BI`pp'=amsperat3
  putexcel BJ`pp'=amsperat4
  putexcel BK`pp'=amsperat5
  putexcel BL`pp'=amsperat6
  putexcel BM`pp'=amsperat7
  putexcel BN`pp'=amsperat8
  putexcel BO`pp'=amsperat9
  putexcel BP`pp'=amsperat10
  putexcel BQ`pp'=amsperat11
  putexcel BR`pp'=amsperat12
  putexcel BS`pp'=amsperat24
  putexcel BT`pp'=amsperat36
  putexcel BU`pp'=aprat1
  putexcel BV`pp'=aprat2
  putexcel BW`pp'=aprat3
  putexcel BX`pp'=aprat4
  putexcel BY`pp'=aprat5
  putexcel BZ`pp'=aprat6
  putexcel CA`pp'=aprat7
  putexcel CB`pp'=aprat8
  putexcel CC`pp'=aprat9
  putexcel CD`pp'=aprat10
  putexcel CE`pp'=aprat11
  putexcel CF`pp'=aprat12
  putexcel CG`pp'=aprat24
  putexcel CH`pp'=aprat36
  putexcel CI`pp'=apmsperat1
  putexcel CJ`pp'=apmsperat2
  putexcel CK`pp'=apmsperat3
  putexcel CL`pp'=apmsperat4
  putexcel CM`pp'=apmsperat5
  putexcel CN`pp'=apmsperat6
  putexcel CO`pp'=apmsperat7
  putexcel CP`pp'=apmsperat8
  putexcel CQ`pp'=apmsperat9
  putexcel CR`pp'=apmsperat10
  putexcel CS`pp'=apmsperat11
  putexcel CT`pp'=apmsperat12
  putexcel CU`pp'=apmsperat24
  putexcel CV`pp'=apmsperat36
  putexcel CW`pp'=apprat1
  putexcel CX`pp'=apprat2
  putexcel CY`pp'=apprat3
  putexcel CZ`pp'=apprat4
  putexcel DA`pp'=apprat5
  putexcel DB`pp'=apprat6
  putexcel DC`pp'=apprat7
  putexcel DD`pp'=apprat8
  putexcel DE`pp'=apprat9
  putexcel DF`pp'=apprat10
  putexcel DG`pp'=apprat11
  putexcel DH`pp'=apprat12
  putexcel DI`pp'=apprat24
  putexcel DJ`pp'=apprat36
            
            
  clear all 
// ***************************

