
# We carry forward the latest observation to fill gaps of at most 7 days
# This removes any short blocks of NAs arising from weekends or public holidays
# However, it won't remove any long blocks of NAs. In particular, it won't remove the block of NAs from 14 Aug 1971 to 22 Aug 1971
# found in the Eikon NERs for many countries. This is the week after Nixon ended the convertibility of the US dollar to gold, contributing to the end of the Bretton Woods system
fill_gaps <- function(ner_gaps) {
  return(map(as.list(ner_gaps), function(z) na.trim(na.locf(z, na.rm = T, fromLast = F, maxgap = 7), sides = "both", is.na = "all")))
}

###################### COMPUTE PERIOD-AVERAGES NERs ###################################

transform_ner <- function(ner_d) {
  # We want ner_d to be free of any NAs. Prior to calling this function, the user will have used fill_gaps to replace
  # any short blocks of up to 7 NAs by carrying forward the last observation.
  # There may, however, be longer gaps, so we extract the part of the series after the last NA
  extract_after_NAs <- function(z) {if(any(is.na(z))) {return(window(z, start = last(index(z)[is.na(z)]) + 1, end = NULL))} else {return(z)}}
  ner_d <- map(ner_d, extract_after_NAs)

  # Compute period-average and period-end series
  ner_transformed <- list(Daily = ner_d,
                          Month_avg = map(ner_d, compute_m_avg),
                          Quarter_avg = map(ner_d, compute_q_avg),
                          Month_end = extract_end_period_values(ner_d, desired_index_class = "yearmon"),
                          Quarter_end = extract_end_period_values(ner_d, desired_index_class = "yearqtr"))
  
  # For each transformation, return any countries that lack data
  remove_null <- function(list) {Filter(function(x) !is.null(x), list)}
  return(map(ner_transformed, remove_null))
}