
### Import and tidy the weights that the Information Notice System (INS) uses for REER calculations
prepare_ins_weights <- function(country_facts) {
  weights_raw <- map(list.files("Raw_data/INS_data/"), function(x) read.xlsx(paste0("Raw_data/INS_data/", x)))
  names(weights_raw) <- list.files("Raw_data/INS_data/")
  
  tidy_weights <- function(raw) {
    # Extract country codes
    extract_reporting <- function(Series_code) {substr(Series_code, start = 1, stop = 3)}
    raw$Reporting.Country.Code <- unlist(map(raw$Series_code, extract_reporting))
    extract_partner <- function(Series_code) {substr(Series_code, start = nchar(Series_code)-4, stop = nchar(Series_code)-2)}
    raw$Partner.Country.Code <- unlist(map(raw$Series_code, extract_partner))
    raw$Combined.Country.Code <- unlist(map2(raw$Reporting.Country.Code, raw$Partner.Country.Code, function(x, y) paste0(x, ".", y)))
    
    # The INS dataset includes the Euro Area as a reporter country (with IFS code 163, https://www.disc.wisc.edu/codebooks/ifscty2002.htm)
    # We only want to compute EERs with countries as reporters, so we remove the rows where the Euro Area is a reporter
    # Fortunately, the INS dataset does not list the Euro Area as a partner country, but rather includes exchange rates and weights for individual Euro Area countries
    raw <- raw[raw$Reporting.Country.Code != "163", ]
    
    # Extract country names
    country_names <- country_facts$country
    ifs_codes <- country_facts$ifs_code
    extract_country_name <- function(ifs_code) {if(ifs_code %in% ifs_codes) {return(country_names[ifs_codes == ifs_code])} else {return(NA)}}
    raw$Reporting.Country.Name <- unlist(map(raw$Reporting.Country.Code, extract_country_name))
    raw$Partner.Country.Name <- unlist(map(raw$Partner.Country.Code, extract_country_name))
    
    # Remove any rows that are missing weights data, which is supposed to be in the column labelled 1970M1.
    raw[!is.na(raw$`1970M1`), ]
  }
  weights <- map(weights_raw, tidy_weights)
  names(weights) <- gsub("LATEST", "2018", gsub(".xlsx", "", gsub("WEIGHT_", "", names(weights))))
  return(weights)
}