
import_imf_ner <- function(directory, country_facts) {
  # Import ENDA from GDS. This is the value of USD in terms of foreign currency
  # I use the suffix 'gaps' to emphasise that, for some countries, enda contains gaps for weekends and public holidays
  enda_gaps_by_spreadsheet <- map(list.files(directory),
                                  function(x) import_weo_vintages_as_zoo(paste0(directory, x), country_facts = country_facts, frequency = "daily")$`Oct 2022`)
  enda_gaps <- Filter(function(x) !all(is.na(x)), do.call(c, enda_gaps_by_spreadsheet))
  
  # The GDS spreadsheet sometimes reports that the value of USD in terms of foreign currency is 0 or negative, which is impossible. I treat these as missing values.
  replace_nonpositive <- function(z) {
    z[z<=0] <- NA
    return(z)
  }
  enda_gaps_positive <- map(enda_gaps, replace_nonpositive)

  # Compute EDNA, which is the value of foreign currency in terms of USD
  return(map(enda_gaps_positive, function(z) 1/z))
}