
### Import Country facts --------------------------------------------------------------

import_country_facts <- function(path) {
  read.xlsx(path) %>%
    mutate(WEO_RGDP_FY_equals_WEO_fiscal_FY = (WEO_rgdp_FY_start == WEO_fiscal_FY_start)) %>%
    rename(AE = "Advanced.Economies", EMDE = "Emerging.and.developing.economies", LIC = "Emerging.Market.and.Developing.Economies:.Low.Income.Developing.Countries") %>%
    mutate(EM = EMDE - LIC) %>%
    mutate(World = 1) %>%
    mutate(Income_group = case_when(AE==1 ~ "AE", EM==1 ~ "EM", LIC==1 ~ "LIC")) %>%
    mutate(Broad_income_group = case_when(AE==1 ~ "AE", EMDE==1 ~ "EMDE")) %>%
    mutate(IMF_region = case_when(AFR==1 ~ "AFR", APD==1 ~ "APD", EUR==1 ~ "EUR", MCD==1 ~ "MCD", WHD==1 ~ "WHD")) %>%
    mutate(EM_ex_Venezuela = case_when(country=="Venezuela" ~ 0, country!="Venezuela" ~ EM)) %>%
    mutate(WHD_ex_Venezuela = case_when(country=="Venezuela" ~ 0, country!="Venezuela" ~ WHD)) %>%
    mutate(World_ex_Venezuela = case_when(country=="Venezuela" ~ 0, country!="Venezuela" ~ World)) %>%
    arrange(country)
}

# Find the country name corresponding to an IFS code
# For countries, this is done by checking country_facts
# For the currency unions, the WEO spreadsheets appear to use 163 for the Euro Area and 309 for Eastern Caribbean Currency Union
# https://www.disc.wisc.edu/codebooks/ifscty2002.htm
identify_country <- function(ifs_code, country_facts) {
  if(ifs_code == "163") {return("Euro Area")}
  if(ifs_code == "309") {return("Eastern Caribbean Currency Union")}
  if(any(ifs_code == country_facts$ifs_code)) {return(as.character(country_facts[which(ifs_code == country_facts$ifs_code), "country"]))} else {return(NA)}
}
identify_country_map <- function(ifs_code_list, country_facts) {unlist(map(ifs_code_list, identify_country, country_facts = country_facts))}

# Find a metadata field in country_facts corresponding to an ISO code
# So far I've used this to extract country names from country_facts, and to extract OECD fiscal year start dates from country facts
use_iso_to_extract_field <- function(iso, field_name, country_facts) {
  if(any(iso == country_facts$iso)) {country_facts[which(iso == country_facts$iso), field_name]} else {return(NA)}
}
use_iso_to_extract_field_map <- function(iso_list, field_name, country_facts) {
  unlist(map(iso_list, use_iso_to_extract_field, field_name = field_name, country_facts = country_facts))
}