* Change to your path
cd "replication_code\output"

import delimited using "ageing_rotemberg.csv", varnames(1) clear

* Main reg
reg delta_gdp_pc delta_60plus i.year, cluster(province)

ivregress 2sls delta_gdp_pc i.year (delta_60plus = delta_pred_over60), cluster(province)

estat firststage

ivregress 2sls delta_gdp_pc i.year agriculture mining manufacturing i.year##c.agriculture i.year##c.mining i.year##c.manufacturing (delta_60plus = delta_pred_over60), cluster(province)

reg delta_gdp_pc delta_60plus i.year coastal i.year##coastal , cluster(province)

ivregress 2sls delta_gdp_pc i.year coastal i.year##coastal (delta_60plus = delta_pred_over60), cluster(province)

* Levels
ivregress 2sls delta_gdp_pc i.year coastal i.year##coastal (delta_60plus_lvls = delta_pred_over60_lvls), cluster(province)

* By year
ivregress 2sls delta_gdp_pc coastal i.year##coastal (delta_60plus = delta_pred_over60) if year==1990, cluster(province)
ivregress 2sls delta_gdp_pc coastal i.year##coastal (delta_60plus = delta_pred_over60) if year==2000, cluster(province)
ivregress 2sls delta_gdp_pc coastal i.year##coastal (delta_60plus = delta_pred_over60) if year==2010, cluster(province)

* Province FE
egen provincenum = group(province)

ivregress 2sls delta_gdp_pc i.year i.provincenum (delta_60plus = delta_pred_over60), cluster(province)

* Rotemberg weights
gen year_1990 = 0
gen year_2000 = 0
gen year_2010 = 0
gen ag_1990 = 0
gen ag_2000 = 0
gen ag_2010 = 0
gen mining_1990 = 0
gen mining_2000 = 0
gen mining_2010 = 0
gen manu_1990 = 0
gen manu_2000 = 0
gen manu_2010 = 0
replace year_1990 = 1 if year==1990
replace year_2000 = 1 if year==2000
replace year_2010 = 1 if year==2010
replace ag_1990 = agriculture if year==1990
replace ag_2000 = agriculture if year==2000
replace ag_2010 = agriculture if year==2010
replace mining_1990 = mining if year==1990
replace mining_2000 = mining if year==2000
replace mining_2010 = mining if year==2010
replace manu_1990 = manufacturing if year==1990
replace manu_2000 = manufacturing if year==2000
replace manu_2010 = manufacturing if year==2010
gen w = 1

local ind_stub pop_share_
local growth_stub weighted_survival_rate_
local x delta_gdp_pc
local y delta_60plus
local controls year_2000 year_2010
local weight w

bartik_weight, z(`ind_stub'*) weightstub(`growth_stub'*) x(`x') y(`y') controls(`controls'  ) weight_var(`weight')

mat beta = r(beta)
mat alpha = r(alpha)
mat gamma = r(gam)
mat pi = r(pi)
mat G = r(G)
qui desc `ind_stub'*, varlist
local varlist = r(varlist)

clear
svmat beta
svmat alpha
svmat gamma
svmat pi
svmat G

gen age = ""
local t = 1
foreach var in `varlist' {
	if regexm("`var'", "`ind_stub'(.*)") {
		qui replace age = regexs(1) if _n == `t'
		}
	local t = `t' + 1
	}

* 30y lag exercise
import delimited using "lag_30.csv", varnames(1) clear

replace delta_pred_over60 = "." if delta_pred_over60 == "NA"
destring delta_pred_over60, replace

ivregress 2sls delta_gdp_pc i.year coastal i.year##coastal (delta_60plus = delta_pred_over60), cluster(province)

* 40y lag exercise
import delimited using "lag_40.csv", varnames(1) clear

ivregress 2sls delta_gdp_pc i.year coastal i.year##coastal (delta_60plus = delta_pred_over60), cluster(province)

* Sector exercise
import delimited using "health_construct.csv", varnames(1) clear

foreach var of varlist * {
cap replace `var' = "" if `var'=="NA"
}

ds
local firstvar `: word 1 of `r(varlist)''
foreach var of varlist `r(varlist)' {
    if "`var'" != "`firstvar'" {
        destring `var', replace
    }
}

ivregress 2sls servicesdiff i.year coastal i.year##coastal (delta_60plus = delta_pred_over60), cluster(province)
ivregress 2sls constructdiff i.year coastal i.year##coastal (delta_60plus = delta_pred_over60), cluster(province)