# The TARS No-code Dashboard 
This folder contains code to build a Text Analysis and Retrieval Tool (TARS) frontend application described in *Section 3 and 4* of the paper An AI-powered Tool for Central Bank Business Liaisons: Quantitative Indicators and On-demand Insights from Firms. 

This application is an R Rhiny dashboard that allows users to efficiently filter liaison textual data stored in the TARS database, without requiring any additional code to be written. 

> Note: The demo data used in this repo has been generated by ChatGPT to broadly reflect the type of text extracted and enriched in Business Liaison TARS database described in the paper. However, given this data is artifical in nature, the output will not exactly reflect measures described in the paper.

# Code Structure
```
Repo
├── Data
│   └── liaison.sqlite (TARS containing liaison-like text data for app demo)
└── frontend
    ├── frontend.Rproj (R project file to ensure working in correct directory)
    ├── requirements.txt (contains package versions required for replication)
    ├── app.R (file to run R Shiny dashboard)
    └── Code
        ├── Function.R (user-defined functions)
        ├── server.R (app execution objects)
        ├── ui.R (app visual objects)
        ├── variables.R (user-defined objects)
        ├── w2v.bin (Word2Vec model binary)
        ├── theme.txt (app manual theme selection) 
        ├── Create_w2v_model.R (non-app code to create Word2Vec model)
        └── markdown
            └── Rmd and PNG files for landing page of application
```

# Getting started
1. Open `frontend.Rproj` to ensure you are working in the correct directory for running each of the scripts. 
2. Open `app.R` and run script
3. Application will open in a browser. If not, check to ensure all files are set out below, or check R console for errors.

### Requirements
For R and package versions of the original paper, see `requirements.txt`. Check your R package versions using `packageVersion("<package_name>")`. Also ensure the nowcasting data (`liaison.sqlite`) is in the `../Data/` directory. The program **RStudio** is needed to open and use the `.Rproj` file in each of the subfolders. In our work we used version 2024.04.0. For more information, see https://www.posit.co.

## File Details
#### frontend.Rproj
R project file to help keep track of file paths, environment settings, and other project-specific options. It is recommended to open files via this project. 

#### ../Data/liaison.sqlite
SQLite database containing the table `liaison_data`. This holds all liaison data that is searched and extracted using the TARS dashboard. The demo data has been generated using ChatGPT to broadly reflect the real liaison textual data used by the RBA. However, given it is artificial in nature, the data will look different to results shown in the paper.

#### requirements.txt
List of R packages and versions used to create working version of dashboard.

#### app.R
The app.R file is the main entry point for the R Shiny application. It sources the necessary scripts and initializes the R Shiny app. The following scripts are sourced within app.R:

* `Code/Function.R`: Contains custom functions used throughout the application.
* `Code/variables.R`: Defines global variables and constants used in the app - INCLUDING the source database and table.
* `Code/ui.R`: Defines the user interface of the R Shiny app.
* `Code/server.R`: Contains the server logic for the R Shiny app.

#### Code/Function.R 
This script includes custom functions that are used to perform various tasks within the application. Functions include SQL code generation and database querying, data processing, calculations and other utility functions.

#### Code/variables.R
This script defines global variables and constants that are used across the application. Specifically, it is where the source database `../Data/liaison.sqlite` and table `liaison_data` is referenced, and from this, defines the selectable options in the side panel of the dashboard e.g. All allowable States and topic tags. It helps in maintaining consistency and makes it easier to manage and update values from a single location.

#### Code/ui.R
This script defines the user interface (UI) of the R Shiny app. It includes the layout and design elements such as inputs, outputs, and overall structure of the dashboard. The UI is built using R Shiny’s UI functions.

#### Code/server.R
This script contains the server-side logic of the R Shiny app. It includes reactive expressions, observers, and output rendering. Specifically, this is where the dashboard takes the filters applied in the UI, then generates and executes SQL queries. The server script processes user inputs and updates the UI accordingly.

#### Code/markdown/
Folder containing all the R markdown files and images for the landing page of the dashboard.

#### Code/w2v.bin
Binary file that contains the word2vec word embedding model parameters used by the dashboard to find semantically similar words for text searches and Topic Builder function.

#### Code/theme.txt
Text file used to set theme of dashboard, including a tag for darkmode themes.
