function [residual, T_order, T] = dynamic_resid(y, x, params, steady_state, T_order, T)
if nargin < 6
    T_order = -1;
    T = NaN(16, 1);
end
[T_order, T] = transition.sparse.dynamic_resid_tt(y, x, params, steady_state, T_order, T);
residual = NaN(13, 1);
    residual(1) = (1) - (params(1)*y(15)/y(28)*(1+y(34)-params(3)));
    residual(2) = (params(5)*y(20)) - (params(1)*y(15)/y(28)*y(35));
    residual(3) = (y(22)) - (y(14)/y(6)*y(24)+y(35)*y(15)*params(1)*(1-params(2))/y(28));
    residual(4) = (y(20)) - (y(15)*params(4)*T(1));
    residual(5) = (y(25)) - (T(5)^(1/(1-params(8))));
    residual(6) = (y(14)) - (y(15)+y(18)-(1-params(3))*y(5)+y(16));
    residual(7) = (y(20)) - (y(14)*T(6)*T(7)/y(17));
    residual(8) = (y(21)) - (y(14)*T(7)*T(8)/y(5));
    residual(9) = (1) - (y(14)*T(10)/y(16));
    residual(10) = (y(23)) - (T(11));
    residual(11) = (y(24)) - (T(12));
    residual(12) = (y(26)) - (T(13));
    residual(13) = (y(25)) - (y(23)/y(26));
end
