clearvars
close all
clc

set(groot, 'DefaultAxesLineWidth', 1.5);
set(groot, 'DefaultLineLineWidth', 3);
set(groot, 'DefaultAxesTickLabelInterpreter','latex'); 
set(groot, 'DefaultLegendInterpreter','latex');
set(groot, 'DefaultAxesFontSize', 22);

%%%% read spreadsheet with compustat average markups

row    = 3;
column = 0;

data = csvread('data/sales_and_cost_weighted_markups_census.csv',row,column); %% ABS data

dates  = data(:,1);

Msales = data(:,2);
Mcost  = data(:,3);

Var    = (Msales-Mcost)./Mcost;

figure(8)
hold on
plot(dates,Mcost,    'color',[ 0.8500    0.3250    0.0980])
plot(dates,Mcost*0.9,'color',[ 0.8500    0.3250    0.0980])
hold off
axis([1967 2017 1 1.5])
xticks(dates)
legend('cost weighted $\mathcal{M}$','Interpreter','latex','Location','NorthWest')
ylabel('average markup','interpreter','latex')
text(2010,1.29,'RTS$=1.0$','interpreter','latex')
text(2010,1.16,'RTS$=0.9$','interpreter','latex')


grid on
box on
print -dpng figures/FigureB1








