% Figure A1: Cost-Weighted vs. Sales-Weighted Average Markups, Compustat



clearvars
close all
clc

set(groot, 'DefaultAxesLineWidth', 1.5);
set(groot, 'DefaultLineLineWidth', 3);
set(groot, 'DefaultAxesTickLabelInterpreter','latex'); 
set(groot, 'DefaultLegendInterpreter','latex');
set(groot, 'DefaultAxesFontSize', 22);

%%%% read spreadsheet with compustat average markups

row    = 3;
column = 0;

data = csvread('data/sales_and_cost_weighted_markups_compustat.csv',row,column); %% ABS data

dates  = data(:,1);

Msales = data(:,2);
Mcost  = data(:,3);

Var    = (Msales-Mcost)./Mcost;

figure(7)
hold on
plot(dates,Msales,dates,Mcost)
axis([1950 2020 1 1.6])
legend('sales-weighted','cost-weighted','Location','NorthWest')
ylabel('average markup','interpreter','latex')
hold off
grid on
box on
print -dpng figures/FigureA1








