% Figure 3: Welfare Gains from Alternative Policies
%
%   loads "benchmark_calibration.mat" with  saved results 
%   
%   for each Mu in [1.05:0.01:1.45]
%
%   loads "benchmark_[scenario].mat" with saved results for each of 4 scenarios
%           scenario1 = efficient
%           scenario2 = uniform_subsidy
%           scenario3 = size_dependent_subsidy
%           scenario4 = entry_subsidy


clearvars;
close all;
clc;

set(groot, 'DefaultAxesLineWidth', 1);
set(groot, 'DefaultLineLineWidth', 3);
set(groot, 'DefaultAxesTickLabelInterpreter','latex'); 
set(groot, 'DefaultLegendInterpreter','latex');
set(groot, 'DefaultAxesFontSize', 22);


load saved_results/benchmark_calibration

% scenario 1:4 =    efficient,
%                   uniform_subsidy,
%                   size_dependent_subsidy,
%                   entry_subsidy 

dW = zeros(numel(Markuptargets),4);


for mm=1:numel(Markuptargets)

for scenario = 1:4

%for mm=2, %1:numel(Markuptargets),

p    = Calibrated_parameters{mm};

Mu   = Markuptargets(mm);

if scenario == 1
load saved_results/benchmark_efficient.mat;
elseif scenario == 2
load saved_results/benchmark_uniform.mat;   
elseif scenario == 3
load saved_results/benchmark_size_dependent.mat;    
else
load saved_results/benchmark_entry.mat;     
end


% welfare
dW(mm,scenario)    = Results{mm}.welfare;



end

end

figure(3)
hold on
plot(Markuptargets,dW(:,1),'color',rgb('DarkSlateBlue'))
plot(Markuptargets,dW(:,2),'color',rgb('Teal'))
plot(Markuptargets,dW(:,3),'color',rgb('SteelBlue'))
plot(Markuptargets,dW(:,4),'color',rgb('DarkRed'))
plot(linspace(1.2,1.4,10),zeros(10,1),'color',rgb('DarkSlateGrey'),'LineWidth',5)
hold off
legend('efficient','uniform subsidy','size-dependent subsidy','entry subsidy','location','NorthWest')
grid on
box on
xlabel('aggregate markup $\mathcal{M}$','Interpreter','latex')
ylabel('welfare, CEV, \%','Interpreter','latex')


print -dpng figures/Figure3




