% Figure 1: Markup Distribution and Misallocation in Benchmark Model
%
%   loads "benchmark_calibration.mat" which has saved results 
%   
%   for each Mu in (1.05:0.01:1.45)
%


clearvars;
close all
clc;
tic;

set(groot, 'DefaultAxesLineWidth', 1);
set(groot, 'DefaultLineLineWidth', 3);
set(groot, 'DefaultAxesTickLabelInterpreter','latex'); 
set(groot, 'DefaultLegendInterpreter','latex');
set(groot, 'DefaultAxesFontSize', 22);

load saved_results/benchmark_calibration % saved results

pp01markups = zeros(numel(Markuptargets),1);
pp05markups = zeros(numel(Markuptargets),1);
pp10markups = zeros(numel(Markuptargets),1);
pp25markups = zeros(numel(Markuptargets),1);
pp50markups = zeros(numel(Markuptargets),1);
pp75markups = zeros(numel(Markuptargets),1);
pp90markups = zeros(numel(Markuptargets),1);
pp95markups = zeros(numel(Markuptargets),1);
pp99markups = zeros(numel(Markuptargets),1);

misallocation    = zeros(numel(Markuptargets),1);
misallocation_va = zeros(numel(Markuptargets),1);

for mm = 1:numel(Markuptargets)

weight = Model_weights{mm};
mu     = Model_markups{mm};

pp01markups(mm)      =  wprctile(mu,  1, weight);
pp05markups(mm)      =  wprctile(mu,  5, weight);
pp10markups(mm)      =  wprctile(mu, 10, weight);
pp25markups(mm)      =  wprctile(mu, 25, weight);
pp50markups(mm)      =  wprctile(mu, 50, weight);
pp75markups(mm)      =  wprctile(mu, 75, weight);
pp90markups(mm)      =  wprctile(mu, 90, weight);
pp95markups(mm)      =  wprctile(mu, 95, weight);
pp99markups(mm)      =  wprctile(mu, 99, weight);

misallocation(mm)    = Model_misallocation{mm};       % gross output
misallocation_va(mm)    = Model_misallocation_va{mm}; % value added, M=1

end



figure(1)
subplot(1,2,1)
hold on
plot(Markuptargets,pp90markups,'r:' ,'LineWidth',0.5)
plot(Markuptargets,pp75markups,'r--','LineWidth',1.5)
plot(Markuptargets,pp50markups,'r-' ,'LineWidth',1.5)
plot(Markuptargets,pp25markups,'r--','LineWidth',1.5)
plot(Markuptargets,pp10markups,'r:' ,'LineWidth',0.5)
plot(Markuptargets,Markuptargets,'k--')
plot(linspace(1.2,1.4,10),ones(10,1),'color',rgb('DarkSlateGrey'),'LineWidth',5)
ylim([1,1.8]) 
hold off
grid on
box on
xlabel('$\mathcal{M}$','interpreter','latex')
ylabel('markup distribution','interpreter','latex')
legend('p90-p10','p75-p25','p50','Location','NorthWest')

subplot(1,2,2)
hold on
plot(Markuptargets,misallocation)
plot(Markuptargets,misallocation_va,'color',rgb('MediumSlateBlue'))
plot(linspace(1.2,1.4,10),zeros(10,1),'color',rgb('DarkSlateGrey'),'LineWidth',5)
hold off
xlabel('$\mathcal{M}$','interpreter','latex')
ylabel('misallocation, \%','interpreter','latex')
legend('gross output losses','value-added losses','Location','NorthWest')
grid on
box on

print -dpng figures/Figure1


