function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 16);

T(1) = (y(6)+params(5)*(y(8)-y(2)*(1-params(2))))^params(6);
T(2) = (y(10)/params(7))^params(7);
T(3) = (y(9)/(1-params(7)))^(1-params(7));
T(4) = T(2)*T(3);
T(5) = params(9)*T(4)^(1-params(8))+1-params(9);
T(6) = params(9)*(1-params(7))/y(15);
T(7) = (T(4)/y(14))^(1-params(8));
T(8) = params(9)*params(7)/y(15);
T(9) = (1/y(14))^(1-params(8));
T(10) = (1-params(9))/y(15)*T(9);
[TEF_0, TEFD_0, TEFDD_0] = interpv(y(2),1);
T(11) = TEF_0;
[TEF_1, TEFD_1, TEFDD_1] = interpv(y(2),2);
T(12) = TEF_1;
[TEF_2, TEFD_2, TEFDD_2] = interpv(y(2),3);
T(13) = TEF_2;
T(14) = TEFD_0(1);
T(15) = TEFD_1(1);
T(16) = TEFD_2(1);

end
