function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = transition.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(13, 1);
lhs = 1;
rhs = params(1)*y(4)/y(16)*(1+y(17)-params(3));
residual(1) = lhs - rhs;
lhs = params(5)*y(9);
rhs = params(1)*y(4)/y(16)*y(18);
residual(2) = lhs - rhs;
lhs = y(11);
rhs = y(3)/y(2)*y(13)+y(18)*y(4)*params(1)*(1-params(2))/y(16);
residual(3) = lhs - rhs;
lhs = y(9);
rhs = y(4)*params(4)*T(1);
residual(4) = lhs - rhs;
lhs = y(14);
rhs = T(5)^(1/(1-params(8)));
residual(5) = lhs - rhs;
lhs = y(3);
rhs = y(4)+y(7)-(1-params(3))*y(1)+y(5);
residual(6) = lhs - rhs;
lhs = y(9);
rhs = y(3)*T(6)*T(7)/y(6);
residual(7) = lhs - rhs;
lhs = y(10);
rhs = y(3)*T(7)*T(8)/y(1);
residual(8) = lhs - rhs;
lhs = 1;
rhs = y(3)*T(10)/y(5);
residual(9) = lhs - rhs;
lhs = y(12);
rhs = T(11);
residual(10) = lhs - rhs;
lhs = y(13);
rhs = T(12);
residual(11) = lhs - rhs;
lhs = y(15);
rhs = T(13);
residual(12) = lhs - rhs;
lhs = y(14);
rhs = y(12)/y(15);
residual(13) = lhs - rhs;

end
