function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = transition.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(13, 18);
g1(1,4)=(-((1+y(17)-params(3))*params(1)/y(16)));
g1(1,16)=(-((1+y(17)-params(3))*(-(params(1)*y(4)))/(y(16)*y(16))));
g1(1,17)=(-(params(1)*y(4)/y(16)));
g1(2,4)=(-(y(18)*params(1)/y(16)));
g1(2,16)=(-(y(18)*(-(params(1)*y(4)))/(y(16)*y(16))));
g1(2,9)=params(5);
g1(2,18)=(-(params(1)*y(4)/y(16)));
g1(3,3)=(-(y(13)*1/y(2)));
g1(3,4)=(-(y(18)*params(1)*(1-params(2))/y(16)));
g1(3,16)=(-(y(18)*(-(y(4)*params(1)*(1-params(2))))/(y(16)*y(16))));
g1(3,2)=(-(y(13)*(-y(3))/(y(2)*y(2))));
g1(3,11)=1;
g1(3,18)=(-(y(4)*params(1)*(1-params(2))/y(16)));
g1(3,13)=(-(y(3)/y(2)));
g1(4,4)=(-(params(4)*T(1)));
g1(4,6)=(-(y(4)*params(4)*T(17)));
g1(4,2)=(-(y(4)*params(4)*T(17)*params(5)*(-(1-params(2)))));
g1(4,8)=(-(y(4)*params(4)*params(5)*T(17)));
g1(4,9)=1;
g1(5,9)=(-(params(9)*T(18)*T(19)*T(20)));
g1(5,10)=(-(T(20)*params(9)*T(19)*T(22)));
g1(5,14)=1;
g1(6,3)=1;
g1(6,4)=(-1);
g1(6,5)=(-1);
g1(6,1)=1-params(3);
g1(6,7)=(-1);
g1(7,3)=(-(T(6)*T(7)/y(6)));
g1(7,6)=(-((-(y(3)*T(6)*T(7)))/(y(6)*y(6))));
g1(7,9)=1-y(3)*T(6)*T(18)/y(14)*T(21)/y(6);
g1(7,10)=(-(y(3)*T(6)*T(21)*T(22)/y(14)/y(6)));
g1(7,14)=(-(y(3)*T(6)*T(21)*(-T(4))/(y(14)*y(14))/y(6)));
g1(7,15)=(-(y(3)*T(7)*(-(params(9)*(1-params(7))))/(y(15)*y(15))/y(6)));
g1(8,3)=(-(T(7)*T(8)/y(1)));
g1(8,1)=(-((-(y(3)*T(7)*T(8)))/(y(1)*y(1))));
g1(8,9)=(-(y(3)*T(8)*T(18)/y(14)*T(21)/y(1)));
g1(8,10)=1-y(3)*T(8)*T(21)*T(22)/y(14)/y(1);
g1(8,14)=(-(y(3)*T(8)*T(21)*(-T(4))/(y(14)*y(14))/y(1)));
g1(8,15)=(-(y(3)*T(7)*(-(params(9)*params(7)))/(y(15)*y(15))/y(1)));
g1(9,3)=(-(T(10)/y(5)));
g1(9,5)=(-((-(y(3)*T(10)))/(y(5)*y(5))));
g1(9,14)=(-(y(3)*(1-params(9))/y(15)*(-1)/(y(14)*y(14))*getPowerDeriv(1/y(14),1-params(8),1)/y(5)));
g1(9,15)=(-(y(3)*T(9)*(-(1-params(9)))/(y(15)*y(15))/y(5)));
g1(10,2)=(-T(14));
g1(10,12)=1;
g1(11,2)=(-T(15));
g1(11,13)=1;
g1(12,2)=(-T(16));
g1(12,15)=1;
g1(13,12)=(-(1/y(15)));
g1(13,14)=1;
g1(13,15)=(-((-y(12))/(y(15)*y(15))));

end
