#!/bin/bash

#SBATCH --job-name=cournot
#SBATCH --nodes=1
#SBATCH --cpus-per-task=5
#SBATCH --mem=120GB
#SBATCH --time=36:00:00
#SBATCH --mail-type=END
#SBATCH --mail-user=jb7026@nyu.edu

module purge
module load matlab/2022a
module load dynare/intel/4.6.3

#### start MATLAB, everything between EOF's is ran in Matlab
#########################################################################
cat<<EOF | srun matlab -nodisplay

warning off MATLAB:maxNumCompThreads:Deprecated
maxNumCompThreads($SLURM_CPUS_PER_TASK);

addpath(genpath('../CompEcon2017'));

start

exit
EOF

#########################################################################

