clear; 
clc;
addpath('G:\Research\JonathanH\EMX 2022 Replication Package\Model\Tables\CompEcon2017\CEtools')

format short g

params = zeros(2,14);

% Markup Fuller sample: Aggr 1.18 to 1.25 harmonic, 1.25 to 1.33 input
% weight
% Es sample Aggr 1.36 to 1.46, input weigh 1.44 to 1.59

% Top 5% share: Unweighted 68 to 70, weighed 73 to 76

% Superelast: Median 0.11, mean 0.13
% TV: around 0.9 up to 0.14 down 0.9 

for option = 1:1

% Agrr Markup, unw concen
if option==1 
   selast = 0.11;
   concen = 0.68; 
   Markuptarget = 1.18;                      % our target for aggregate markup
   p.xi         = 5.6767;          % Pareto tail productivity
   p.sigma      = 9.0084;          % demand elasticity: match level of markups 
elseif  option==2                           
   selast = 0.11;
   concen = 0.70; 
   Markuptarget = 1.25;                      % our target for aggregate markup   
 p.xi         = 4.0581;          % Pareto tail productivity
   p.sigma      = 7.0387;          % demand elasticity: match level of markups 
% Agrr Markup, w concen
elseif option==3 
   selast = 0.11;
   concen = 0.73; 
   Markuptarget = 1.18;                      % our target for aggregate markup
   p.xi         = 5.6272;          % Pareto tail productivity
   p.sigma      = 9.3718;          % demand elasticity: match level of markups 
elseif  option==4                          
   selast = 0.11;
   concen = 0.76; 
   Markuptarget = 1.25;                      % our target for aggregate markup   
   p.xi         = 4.028;          % Pareto tail productivity
    p.sigma      = 7.3889;          % demand elasticity: match level of markups 
% Est sample MU, unw concen
elseif  option==5                          
   selast = 0.11;
   concen = 0.68; 
   Markuptarget = 1.36;                      % our target for aggregate markup
    p.xi         = 3.095061180708260;          % Pareto tail productivity
    p.sigma      = 5.479458277757432;          % demand elasticity: match level of markups 
elseif  option==6                           
   selast = 0.11;
   concen = 0.70; 
   Markuptarget = 1.46;                      % our target for aggregate markup
       p.xi         = 3.095061180708260;          % Pareto tail productivity
    p.sigma      = 5.479458277757432;          % demand elasticity: match level of markups 
% Agrr Markup, w concen
elseif option==7 
   selast = 0.11;
   concen = 0.73; 
   Markuptarget = 1.36;                      % our target for aggregate markup
    p.xi         = 3.095061180708260;          % Pareto tail productivity
    p.sigma      = 5.479458277757432;          % demand elasticity: match level of markups 

elseif  option==8                          
   selast = 0.11;
   concen = 0.76; 
   Markuptarget = 1.46;                      % our target for aggregate markup    
    p.xi         = 3.095061180708260;          % Pareto tail productivity
    p.sigma      = 5.479458277757432;          % demand elasticity: match level of markups 



% Agrr Markup cost weighted, unw concen
elseif option==9 
   selast = 0.11;
   concen = 0.68; 
   Markuptarget = 1.25;                      % our target for aggregate markup
   p.xi         = 5.6767;          % Pareto tail productivity
   p.sigma      = 9.0084;          % demand elasticity: match level of markups 
elseif  option==10                           
   selast = 0.11;
   concen = 0.70; 
   Markuptarget = 1.33;                      % our target for aggregate markup   
 p.xi         = 4.0581;          % Pareto tail productivity
   p.sigma      = 7.0387;          % demand elasticity: match level of markups 
% Agrr Markup, w concen
elseif option==11 
   selast = 0.11;
   concen = 0.73; 
   Markuptarget = 1.25;                      % our target for aggregate markup
   p.xi         = 5.6272;          % Pareto tail productivity
   p.sigma      = 9.3718;          % demand elasticity: match level of markups 
elseif  option==12                          
   selast = 0.11;
   concen = 0.76; 
   Markuptarget = 1.33;                      % our target for aggregate markup   
   p.xi         = 4.028;          % Pareto tail productivity
    p.sigma      = 7.3889;          % demand elasticity: match level of markups 

elseif  option==13                           
   selast = 0.11;
   concen = 0.70; 
   Markuptarget = 1.22;                      % our target for aggregate markup   
 p.xi         = 4.0581;          % Pareto tail productivity
   p.sigma      = 7.0387;          % demand elasticity: match level of markups 
elseif  option==14                           
   selast = 0.11;
   concen = 0.70; 
   Markuptarget = 1.29;                      % our target for aggregate markup
       p.xi         = 3.095061180708260;          % Pareto tail productivity
    p.sigma      = 5.479458277757432;          % demand elasticity: match level of markups 
end
    % Markuptarget = 1.05; 
% 
% p.xi         = 20.7021016669651;          % Pareto tail productivity
% p.sigma      = 29.1008275310716;          % demand elasticity: match level of markups 
% 
% 
% Markuptarget = 1.10;                      % our target for aggregate markup
% 
% p.xi         = 10.2987999947552;          % Pareto tail productivity
% p.sigma      = 15.3992042842566;          % demand elasticity: match level of markups 
% 
% 
% Markuptarget = 1.15; 
% 
% p.xi         =  6.8409724072258;          % Pareto tail productivity
% p.sigma      = 10.8610835311753;          % demand elasticity: match level of markups 
% 
% 
% Markuptarget = 1.20;                      % our target for aggregate markup
% 
% %p.xi         = 5.10453727185321;          % Pareto tail productivity
% p.xi         = 5.149964199799157;          % Pareto tail productivity
% %p.sigma      = 8.56704900543676;          % demand elasticity: match level of markups 
% p.sigma      = 8.023970305452329;          % demand elasticity: match level of markups 
% 
% 
% Markuptarget = 1.15;                      % our target for aggregate markup
% 
% %p.xi         = 5.10453727185321;          % Pareto tail productivity
% p.xi         = 6.978841315684244;          % Pareto tail productivity
% %p.sigma      = 8.56704900543676;          % demand elasticity: match level of markups 
% p.sigma      = 9.899084654227150;          % demand elasticity: match level of markups 
% 
% 
% Markuptarget = 1.25;                      % our target for aggregate markup
% 
% %p.xi         = 5.10453727185321;          % Pareto tail productivity
% p.xi         = 4.150406199949516;          % Pareto tail productivity
% %p.sigma      = 8.56704900543676;          % demand elasticity: match level of markups 
% p.sigma      = 6.541864328113578;          % demand elasticity: match level of markups 
% 
% 
% 
% Markuptarget = 1.33;                      % our target for aggregate markup
% 
% %p.xi         = 5.10453727185321;          % Pareto tail productivity
% p.xi         = 3.095061180708260;          % Pareto tail productivity
% %p.sigma      = 8.56704900543676;          % demand elasticity: match level of markups 
% p.sigma      = 5.479458277757432;          % demand elasticity: match level of markups 
% 

% 
% Markuptarget = 1.25;                      % our target for aggregate markup
% 
% p.xi         = 4.06857848423202;          % Pareto tail productivity
% p.sigma      = 7.2079290139342;           % demand elasticity: match level of markups 
% 
% 
% Markuptarget = 1.30;                      % our target for aggregate markup
% 
% p.xi         = 3.37950775326023;          % Pareto tail productivity
% p.sigma      = 6.30583163623233;          % demand elasticity: match level of markups 
% 
% 
% Markuptarget = 1.35;                      % our target for aggregate markup
% 
% p.xi         = 2.88859963714985;          % Pareto tail productivity
% p.sigma      = 5.66479780771211;          % demand elasticity: match level of markups 


x            = [p.xi;   p.sigma];
 
lb           = [2;       4];  
ub           = [20;       20];

ftarget      = @(x) objective(x, Markuptarget, selast, concen );



options             = optimset('fminsearch');
options.Display     = 'iter';
options.TolX        = 1e-5;
options.MaxFunEvals = 200;

x                   = fminsearchbnd(ftarget, x, lb, ub, options);
 

params(:,option) = x;
end

  