function residual = static_resid(T, y, x, params, T_flag)
% function residual = static_resid(T, y, x, params, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T         [#temp variables by 1]  double   vector of temporary terms to be filled by function
%   y         [M_.endo_nbr by 1]      double   vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1]       double   vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1]     double   vector of parameter values in declaration order
%                                              to evaluate the model
%   T_flag    boolean                 boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = transition.static_resid_tt(T, y, x, params);
end
residual = zeros(13, 1);
    residual(1) = (1) - (params(1)*(1+y(8)-params(3)));
    residual(2) = (params(5)*y(7)) - (params(1)*y(9));
    residual(3) = (y(9)) - (y(1)/y(6)*y(11)+y(9)*params(1)*(1-params(2)));
    residual(4) = (y(7)) - (y(2)*params(4)*T(1));
    residual(5) = (y(12)) - (T(5)^(1/(1-params(8))));
    residual(6) = (y(1)) - (y(2)+y(5)-y(5)*(1-params(3))+y(3));
    residual(7) = (y(7)) - (y(1)*T(6)*T(7)/y(4));
    residual(8) = (y(8)) - (y(1)*T(7)*T(8)/y(5));
    residual(9) = (1) - (y(1)*T(10)/y(3));
    residual(10) = (y(10)) - (T(11));
    residual(11) = (y(11)) - (T(12));
    residual(12) = (y(13)) - (T(13));
    residual(13) = (y(12)) - (y(10)/y(13));

end
