function residual = static_resid(T, y, x, params, T_flag)
% function residual = static_resid(T, y, x, params, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T         [#temp variables by 1]  double   vector of temporary terms to be filled by function
%   y         [M_.endo_nbr by 1]      double   vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1]       double   vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1]     double   vector of parameter values in declaration order
%                                              to evaluate the model
%   T_flag    boolean                 boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = transition.static_resid_tt(T, y, x, params);
end
residual = zeros(13, 1);
lhs = 1;
rhs = params(1)*(1+y(8)-params(3));
residual(1) = lhs - rhs;
lhs = params(5)*y(7);
rhs = params(1)*y(9);
residual(2) = lhs - rhs;
lhs = y(9);
rhs = y(1)/y(6)*y(11)+y(9)*params(1)*(1-params(2));
residual(3) = lhs - rhs;
lhs = y(7);
rhs = y(2)*params(4)*T(1);
residual(4) = lhs - rhs;
lhs = y(12);
rhs = T(5)^(1/(1-params(8)));
residual(5) = lhs - rhs;
lhs = y(1);
rhs = y(2)+y(5)-y(5)*(1-params(3))+y(3);
residual(6) = lhs - rhs;
lhs = y(7);
rhs = y(1)*T(6)*T(7)/y(4);
residual(7) = lhs - rhs;
lhs = y(8);
rhs = y(1)*T(7)*T(8)/y(5);
residual(8) = lhs - rhs;
lhs = 1;
rhs = y(1)*T(10)/y(3);
residual(9) = lhs - rhs;
lhs = y(10);
rhs = T(11);
residual(10) = lhs - rhs;
lhs = y(11);
rhs = T(12);
residual(11) = lhs - rhs;
lhs = y(13);
rhs = T(13);
residual(12) = lhs - rhs;
lhs = y(12);
rhs = y(10)/y(13);
residual(13) = lhs - rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
end
