
*Title: "HANK and the Transmission of Shocks to Demand and Supply"
*Authors: Karsten Chipeniuk, Gulnara Nolan and Matt Nolan 






clear all

cd "P:\folder"


use "R:\madip-ge-020139d-ato-atoitrincloss1819-fy2018-19\madip-ge-020139d-ato-atoitrincloss1819-fy2018-19\ato_itr_inc_loss_1819.dta", clear


gen year2019=1

keep SYNTHETIC_AEUID GRS_PMT_TOTL_CALCD_AMT year2019 INCM_YR

duplicates drop

****wages and GRS_PMT_TOTL_CALCD_AMT


append using "R:\madip-ge-020139d-ato-atoitrincloss1718-fy2017-18\ato_itr_inc_loss_1718.dta"


sort SYNTHETIC_AEUID
keep SYNTHETIC_AEUID GRS_PMT_TOTL_CALCD_AMT year2019 INCM_YR


save "P:\folder\18_19.dta", replace

gen year=.
replace year=2019 if year2019==1
replace year=2018 if year2019==.

rename GRS_PMT_TOTL_CALCD_AMT wages

gen cpiwage2019=wages*101.091071/102.7833445 if year==2019
replace cpiwage2019=wages if year==2018

gen cpilwages=log(cpiwage2019)

gen lwages=log(wages)

egen id=group(SYNTHETIC_AEUID)


tsset id year 


*********************************


gen l_diff=cpilwages-l.cpilwages if cpilwages!=. & l.cpilwages!=.

egen fraction_with_10_percent=mean(l_diff) if abs(l_diff)<0.1
egen fraction_with_20_percent=mean(l_diff) if abs(l_diff)<0.2
egen fraction_with_50_percent=mean(l_diff) if abs(l_diff)<0.5


preserve 
egen maxc=max(cpilwages)
drop if cpilwages==maxc
drop maxc
egen maxc=max(cpilwages)
sum maxc

restore


gen p_10=(abs(l_diff)<0.1) if l_diff!=.
gen p_20=(abs(l_diff)<0.2) if l_diff!=.
gen p_50=(abs(l_diff)<0.5) if l_diff!=.

preserve 
egen max10=max(l_diff) if abs(l_diff)<0.1
drop if l_diff==max10
drop max10
egen max10=max(l_diff) if abs(l_diff)<0.1
sum max10

restore



gen cpidlw=d.cpilwages
gen dlw=d.lwages

moments dlw
moments cpidlw

egen maxlw=max(dlw)
egen totlw=total(dlw)

gen perccont=maxlw/totlw

egen cpimaxlw=max(cpidlw)
egen cpitotlw=total(cpidlw)


gen cpiperccont=cpimaxlw/cpitotlw


tab maxlw
tab totlw
tab perccont


tab cpimaxlw
tab cpitotlw
tab cpiperccont 



*************
**** 5yr diff
clear all 
cd "P:folder"

use "R:\madip-ge-020139d-ato-atoitrincloss1819-fy2018-19\madip-ge-020139d-ato-atoitrincloss1819-fy2018-19\ato_itr_inc_loss_1819.dta", clear

gen year2019=1

append using "R:\madip-ge-020119d-ato-atoitrincloss1314-fy2013-14\madip-ge-020119d-ato-atoitrincloss1314-fy2013-14\ato_itr_inc_loss_1314.dta"

keep SYNTHETIC_AEUID GRS_PMT_TOTL_CALCD_AMT year2019 INCM_YR



gen year=.
replace year=2019 if year2019==1
replace year=2018 if year2019==.

gen cpiwage2019=wages*94.7673124/102.7833445 if year==2019
replace cpiwage2019=wages if year==2018


save "P:\folder\14_19.dta", replace














































