% Compute number of draws required to control approximation error for
% bounds of identified set using results in Montiel Olea and Nesbit (2021).

clear variables
close all
clc

d = 3*3*21; % Dimension of identified set (number of impulse responses)
% Misclassification parameters - misclassification error of at most epsilon
% with probability at least 1-delta.
epsilon = 0.05; 
delta = 0.05;

% Compute lower and upper bounds on number of required draws
lb = (1-epsilon)*log(1/delta)/epsilon;
ub = min(2*d*log(2*d/delta),exp(1)*(2*d+log(1/delta)))/epsilon;

% Plot iso-draw curves (combinations of (epsilon,delta) such that number of
% draws M attains upper bound).
M = ub;
deltas = linspace(0.001,1,1000)'; 
epsilons = zeros(length(deltas),length(M));
for ii = 1:length(M)

    epsilons(:,ii) = min(2*d*log(2*d./deltas),exp(1)*(2*d+log(1./deltas)))./M(ii);

end

figure;
plot(deltas,epsilons,'LineWidth',2,'color','blue');
% ylim([0 1]);
xlabel('$$\delta$$','Interpreter','latex');
ylabel('$$\epsilon$$','interpreter','latex');
% title('Iso-draw Curves');
% lgnd = cell(length(M),1);
% for ii = 1:length(M)
%     lgnd{ii} = sprintf('M = %d',M(ii));
% end
% legend(lgnd,'Location','Best');
% legend boxoff;
cd('Figures');
print('isodraw','-depsc');

% Export figure data to Excel
outmat = [deltas, epsilons];
writematrix(outmat,'GraphData.xlsx','Sheet','isodraw');

cd ..