%% Construct data for estimating VAR for y_t.
YY = data(opt.p+1:end,:); % y_t 
XX = lags(data,1:opt.p); % Matrix of regressors in VAR for y_t
XX = XX(opt.p+1:end,:); % Drop initial missing observations
if opt.const == 1 % Add constant to matrix of regressors
    XX = [XX ones(size(XX,1),1)];
end
% Add exogenous variables to matrix of regressors
XX = [XX exog(opt.p+1:end,:)]; 

n = size(YY,2); % Number of variables
m = size(XX,2); % Number of parameters in each equation for y_t
nExog = opt.const + size(exog,2); % Number of exogenous variables
T = length(YY); % Number of observations used in estimating VAR

% Adjust indices representing narrative restrictions to account for
% losing the first p observations. If the restrictions are imposed in the 
% first p periods of the original dataset, drop the restrictions.
if ~isempty(restr.shockSign)
    restr.shockSign(:,3) = restr.shockSign(:,3) - opt.p;
    restr.shockSign(restr.shockSign(:,3) <= 0) = [];
end
if ~isempty(restr.hdSign)
    restr.hdSign(:,3) = restr.hdSign(:,3) - opt.p;
    restr.hdSign(restr.hdSign(:,3) <= 0) = [];
end

%% Conduct posterior inference on impulse responses.
% j-th column of B gives OLS estimate of coefficients in j-th reduced form 
% VAR equation. Last rows correspond to exogenous terms (if included).
phiHat.B = (XX'*XX)\XX'*YY;
phiHat.S = (YY - XX*phiHat.B)'*(YY-XX*phiHat.B);
phiHat.Sigma = (1/T)*phiHat.S; % MLE of innovation covariance matrix
phiHat.P = (XX'*XX)\eye(m);
phiHat.cholP = chol(phiHat.P,'lower');

% Storage arrays.
eta = zeros(n,n,opt.H+1,opt.nonEmpty*opt.qDraws);
draw = 0; % Counter for no. of draws of phi with nonempty identified set
phiDraw = 0; % Counter for no. of draws of phi

tic

while draw < opt.nonEmpty

    phiDraw = phiDraw + 1;

    % Posterior sampler with independent improper (Jeffreys) prior.
    phi.Sigma = iwishrnd(phiHat.S,T-m);
    phi.Sigmatr = chol(phi.Sigma,'lower');
    phi.Sigmatrinv = phi.Sigmatr\eye(n);
    phi.B = phiHat.B(:) + kron(phi.Sigmatr,phiHat.cholP)*randn(m*n,1);

    % Generate coefficients in orthogonal reduced-form VMA representation.
    phi.vma = genVMA(phi,opt,nExog);
        
    % Compute reduced-form VAR innovations.
    phi.U = (YY - XX*reshape(phi.B,m,n))';
    
    % Attempt to obtan qDraws draws of Q from uniform distribution over
    % identified set. If no draws can be obtained after qMax draws, 
    % approximate identified set as empty and draw another value of phi.
    
    Qs = zeros([n,n,opt.qDraws]);

    % Determine whether identified set is nonempty.
    [Qs(:,:,1),restr.sphi,empty] = drawQ0_ar(restr,phi,opt);

    % If nonempty, draw another qDraws - 1 times.
    if empty == 0 % If identified set non-empty

        draw = draw + 1;

        Qs(:,:,2:end) = drawQs_ar(restr,phi,opt);

        % Compute associated draws of impulse responses.

        for hh = 1:opt.H+1 % For each horizon
    
            eta(:,:,hh,((draw-1)*opt.qDraws + 1):(draw*opt.qDraws)) = ...
                pagemtimes(phi.vma(:,:,hh),Qs);

        end

       if mod(opt.nonEmpty-draw,opt.dispIter) == 0
          
           fprintf('\n%d draws from reduced-form posterior remaining...',...
           opt.nonEmpty-draw);

       end

    end

end

runTime = toc;

% Compute cumulative impulse response for draws where necessary.
if ~isempty(opt.cumIR)
    eta(opt.cumIR,:,:,:) = cumsum(eta(opt.cumIR,:,:,:),3);
end

etaMean = mean(eta,4); % Compute posterior means.
etaMedian = median(eta,4); % Compute posterior medians.
% Compute equi-tailed credible intervals
credlb = quantile(eta,(1-opt.aalpha)/2,4);
credub = quantile(eta,(1+opt.aalpha)/2,4);

% Compute posterior plausibility (probability of nonempty identified set)
postPlaus = draw/phiDraw;
sprintf('Posterior plausibility is %f per cent',100*postPlaus)