% Generate figures - oil market, standard Bayesian, comparison of sampling
% approaches.

clear variables
close all
clc

cd Results
load('OilMarket_ss.mat');

etaMedian_ss = etaMedian;
credlb_ss = credlb;
credub_ss = credub;
clearvars -except etaMedian_ss credlb_ss credub_ss

load('OilMarket_ar.mat');
etaMedian_ar = etaMedian;
credlb_ar = credlb;
credub_ar = credub;
clearvars -except etaMedian_ar credlb_ar credub_ar etaMedian_ss credlb_ss credub_ss opt varNames shockNames

cd ..

figure;
counter = 0;
for ii = 1:3 % Variables
for jj = 1:3 % Shocks
    counter = counter + 1;
    subplot(3,3,counter);
    h1 = plot(0:opt.H,squeeze(etaMedian_ss(ii,jj,:)),'color','blue');
    hold on;
    h2 = plot(0:opt.H,squeeze(etaMedian_ar(ii,jj,:)),'color','red');
    h3 = plot(0:opt.H,squeeze(credlb_ss(ii,jj,:)),'color','blue','LineStyle','--');
    h4 = plot(0:opt.H,squeeze(credlb_ar(ii,jj,:)),'color','red','LineStyle','--');
    plot(0:opt.H,squeeze(credub_ss(ii,jj,:)),'color','blue','LineStyle','--');
    plot(0:opt.H,squeeze(credub_ar(ii,jj,:)),'color','red','LineStyle','--');
    line([0 opt.H],[0 0],'color','black','LineStyle',':');
    if ii == 1
    title(shockNames(jj));
    end
    if jj == 1
    ylabel(strcat(varNames(ii),{' (%)'}));
    end
    if ii == 3
    xlabel('Horizon (months)');
    end
    if ii == 1
        ylim([-3 12]);
    elseif ii == 2
        ylim([-2 2]);
    elseif ii == 3
        ylim([-3 12]);
    end
end
end
cd Figures
print('oilMarket_bayes','-depsc');

% Export figure data to Excel
hors = (0:opt.H)';
for ii = 1:3 % For each variable
    for jj = 1:3 % For each shock
        
        outmat = [hors,squeeze(etaMedian_ss(ii,jj,:)),squeeze(credlb_ss(ii,jj,:)),squeeze(credub_ss(ii,jj,:)),...
            squeeze(etaMedian_ar(ii,jj,:)),squeeze(credlb_ar(ii,jj,:)),squeeze(credub_ar(ii,jj,:))];
        writematrix(outmat,'GraphData_oilStandard.xlsx','Sheet',string(strcat(varNames(ii),shockNames(jj))));

    end
end

cd ..

