% Examine performance of accept-reject sampling in monetary policy SVAR.
% Need to have run MonetaryPolicy_ss.m before running this script (at 
% least up to point where preliminaries are saved in 
% MonetaryPolicy_setup.mat).

clear variables
close all
clc

addpath('auxFunctions');

% Load data, options, restrictions etc set up in MonetaryPolicy_ss.m
cd Results
load('MonetaryPolicy_setup.mat');
cd ..

% Obtain results using accept-reject
% At each draw of reduced-form parameters, terminate accept-reject 
% algorithm if no draws obtained satisfying restrictions after qMax draws
opt.qMax = 1e3; 
svar_ar;

drawph = opt.qDraws*opt.nonEmpty/(runTime/(60*60));
sprintf('Number of draws per hour: %f',drawph)

% Drop impulse responses corresponding to non-identified shocks
eta = squeeze(eta(:,1,:,:));
etaMean = squeeze(etaMean(:,1,:));
etaMedian = squeeze(etaMedian(:,1,:));
credlb = squeeze(credlb(:,1,:));
credub = squeeze(credub(:,1,:));

cd Results
save('MonetaryPolicy_ar.mat');
cd ..