% This script replicates all results in the paper.
clear variable
close all
clc

%% Figure 1
% Illustrate regularisation function.
penaltyIllustration;

%% Figure 3
% Illustrate sampling via soft sign restrictions using bivariate model.
MonteCarlo_figures;

%% Table 1
% Compare computational performance of sampling via accept-reject vs soft
% sign restrictions via Monte Carlo study. Data-generating process is
% bivariate model.
MonteCarlo;

%% Figure 4
% Illustrate sampling via soft sign restrictions using bivariate model when
% the identified set is disconnected.
MonteCarlo_disconnected_figures;

%% Figure 5
% Compare soft sign restrictions and accept-reject sampling when
% approximating posterior of impulse responses in oil market model from
% Antolin-Diaz and Rubio-Ramirez (2018).
OilMarket_ss; % Generate results based on soft sign restrictions
OilMarket_ar; % Generate results based on accept-reject sampler
OilMarket_figure; % Produce version of Figure 5

%% Table 2
% Compare performance of sampling algorithms, including with different
% values of regularisation parameter, in oil market model.
OilMarket_deltas;

%% Figure 6 (+ Table B1)
% Implement robust Bayesian procedure in oil market model using soft sign
% restrictions approach to sampling. Implementation here makes use of
% Parallel Computing Toolbox. Change 'parfor' to 'for' in svar_ss_rob.m if
% you do not have this toolbox.
OilMarket_robust;
% Produce version of Figure 6, construct prior informativeness statistic
% (Table B1) and export to Excel
OilMarket_robust_figure; 

%% Figure 7 (+ Table B2)
% Use robust Bayesian procedure, implemented via soft sign restrictions, to
% examine informativeness of different narrative restrictions 
OilMarket_robust_baseline; % Sign + elasticity restrictions only
OilMarket_robust_restr; % August 1990 restriction on historical decomp only
% Produce version of Figure 7, construct restrictions informativeness
% statistic (Table B2) and export to Excel
OilMarket_restrInf;

%% Figure B.1
% Compute number of draws required to control error when approximating 
% identified sets in robust Bayesian approach. Plot the 'isodraw' curve.
isodrawcurve;

%% Figure B.2
% Compare soft sign restrictions and accept-reject sampling when
% approximating posterior of impulse responses in monetary policy model 
% from Antolin-Diaz and Rubio-Ramirez (2018).
MonetaryPolicy_ss; % Generate results based on soft sign restrictions
MonetaryPolicy_ar; % Generate results based on accept-reject sampling
MonetaryPolicy_figure; % Produce version of Figure B.2

%% Section 5.4.2
% Repeat analysis underlying Figure 5, using alternative method to check
% whether identified sets are empty.
OilMarket_ss_chebycheck;
OilMarket_ar_chebycheck;
