% Illustrate regularlisation function.

clear variables
close all
clc

Deltas = [0.1, 0.01, 0.001]'; 

% Assume restriction is of the form S(phi,Q) >= 0

% Define anonymous function representing regularisation function
Lambda = @(f,Delta) (1+exp(-f./Delta)).^(-1);

% Plot regularisation function given different values of Delta
sGrid = linspace(-1,1,1000)';

colour_green = [0 153 0]./255;
colour_blue = [0 255 255]./255;
colour_magenta = [255 0 255]./255;

figure;
plot(sGrid,Lambda(sGrid,Deltas(1)),'color',colour_green,'LineWidth',2);
hold on;
plot(sGrid,Lambda(sGrid,Deltas(2)),'color',colour_blue,'LineWidth',2);
plot(sGrid,Lambda(sGrid,Deltas(3)),'color',colour_magenta,'LineWidth',2);
xlabel('$$f$$','Interpreter','latex');
ylabel('$$\Lambda(f,\Delta)$$','interpreter','LaTeX');
% title('Regularisation Function');
h1_str = ['$$\Delta = ',num2str(Deltas(1)),'$$'];
h2_str = ['$$\Delta = ',num2str(Deltas(2)),'$$'];
h3_str = ['$$\Delta = ',num2str(Deltas(3)),'$$'];
legend(h1_str,h2_str,h3_str,'Interpreter','latex','Location','NorthWest');
legend boxoff;
set(findall(gcf,'-property','FontSize'),'FontSize',14);
cd Figures
print('penaltyFunction','-depsc');
cd ..

% Write underlying graph data to Excel
cd Figures
outmat = [sGrid, Lambda(sGrid,Deltas(1)), ...
    sGrid, Lambda(sGrid,Deltas(2)), ...
    sGrid, Lambda(sGrid,Deltas(3))];
writematrix(outmat,'GraphData.xlsx','Sheet','penalty');
cd .. 




