% Plot impulse responses to oil market shocks obtained using standard and
% robust Bayesian procedures.

clear variables
close all
clc

cd Results
load('OilMarket_rob.mat');
clearvars -except etaMedianlb etaMedianub robCredlb robCredub
load('OilMarket_ss.mat');
cd ..

figure;
counter = 0;
for ii = 1:3 % Variables
for jj = 1:3 % Shocks
    counter = counter + 1;
    subplot(3,3,counter);
    plot(0:opt.H,squeeze(etaMedianlb(ii,jj,:)),'color','blue');
    hold on;
    plot(0:opt.H,squeeze(etaMedianub(ii,jj,:)),'color','blue');
    plot(0:opt.H,squeeze(etaMedian(ii,jj,:)),'color','red');
    plot(0:opt.H,squeeze(robCredlb(ii,jj,:)),'color','blue','LineStyle','--');
    plot(0:opt.H,squeeze(robCredub(ii,jj,:)),'color','blue','LineStyle','--');
    plot(0:opt.H,squeeze(credlb(ii,jj,:)),'color','red','LineStyle','--');
    plot(0:opt.H,squeeze(credub(ii,jj,:)),'color','red','LineStyle','--');
    line([0 opt.H],[0 0],'color','black','LineStyle',':');
    ylabel('%');
    if ii == 1
    title(shockNames(jj));
    end
    if jj == 1
    ylabel(strcat(varNames(ii),{' (%)'}));
    end
    if ii == 3
    xlabel('Horizon (months)');
    end
    if ii == 1
        ylim([-5 10]);
    elseif ii == 2
        ylim([-2 2]);
    elseif ii == 3
        ylim([-3 12]);
    end
end
end

cd Figures
print('oilMarket_rob_comb','-depsc');

% Export figure data to Excel
hors = (0:opt.H)';
for ii = 1:3 % For each variable
    for jj = 1:3 % For each shock
        
        outmat = [hors,squeeze(etaMedianlb(ii,jj,:)),squeeze(etaMedianub(ii,jj,:)),...
            squeeze(robCredlb(ii,jj,:)),squeeze(robCredub(ii,jj,:)),...     
        squeeze(etaMedian(ii,jj,:)),squeeze(credlb(ii,jj,:)),squeeze(credub(ii,jj,:))];
        writematrix(outmat,'GraphData_oilrob.xlsx','Sheet',string(strcat(varNames(ii),shockNames(jj))));

    end
end

cd ..

%% Compute prior informativeness statistic from GK21
% Based on ratio of widths of standard and robust credible intervals
priorInf = 1 - (credub - credlb)./(robCredub - robCredlb);
priorInf_avg = mean(priorInf,3); % Average across horizons

% Construct table and export to Excel
priorInf_tab = cell([3,8]);
priorInf_tab(:,2:2:6) = {'&'};
priorInf_tab(:,end) = {'\\'};
priorInf_tab(:,1) = {'Activity','Production','Price'};
priorInf_tab(:,[3,5,7]) = num2cell(priorInf_avg);
cd Results
writecell(priorInf_tab,'info_stats.xlsx','Sheet','prior');
cd ..
