% Plot impulse responses to oil market shocks obtained using robust 
% Bayesian procedures under different sets of identifying restrictions.

clear variables
close all
clc

cd Results
load('OilMarket_rob_baseline.mat'); % Baseline - sign and elasticity only
etaMedianlb_0 = etaMedianlb;
etaMedianub_0 = etaMedianub;
robCredlb_0 = robCredlb;
robCredub_0 = robCredub;
clearvars -except etaMedianlb_0 etaMedianub_0 robCredlb_0 robCredub_0

load('OilMarket_rob_restr.mat'); % Model 1 - baseline + August 1990
etaMedianlb_1 = etaMedianlb;
etaMedianub_1 = etaMedianub;
robCredlb_1 = robCredlb;
robCredub_1 = robCredub;
clearvars -except etaMedianlb_0 etaMedianub_0 robCredlb_0 robCredub_0 etaMedianlb_1 etaMedianub_1 robCredlb_1 robCredub_1

load('OilMarket_rob.mat'); % Model 2 - full set
etaMedianlb_2 = etaMedianlb;
etaMedianub_2 = etaMedianub;
robCredlb_2 = robCredlb;
robCredub_2 = robCredub;
clearvars -except etaMedianlb_0 etaMedianub_0 robCredlb_0 robCredub_0 etaMedianlb_1 etaMedianub_1 robCredlb_1 robCredub_1 etaMedianlb_2 etaMedianub_2 robCredlb_2 robCredub_2 shockNames varNames opt

cd ..

color_blue = [0, 0, 255]./255;
color_lightblue = [0, 255, 255]./255;
color_green = [0, 102, 0]./255;
color_lightgreen = [128, 255, 0]./255;
color_purp = [153, 0, 153]./255;
color_lightpurp = [255, 102, 255]./255;

figure;
counter = 0;
for ii = 1:3 % Variables
for jj = 1:3 % Shocks
    counter = counter + 1;
    subplot(3,3,counter);
    plot(0:opt.H,squeeze(etaMedianlb_0(ii,jj,:)),'color',color_blue);
    hold on;
    plot(0:opt.H,squeeze(etaMedianub_0(ii,jj,:)),'color',color_blue);
    % plot(0:opt.H,squeeze(robCredlb_0(ii,jj,:)),'color',color_lightblue,'LineStyle','--');
    % plot(0:opt.H,squeeze(robCredub_0(ii,jj,:)),'color',color_lightblue,'LineStyle','--');
    plot(0:opt.H,squeeze(etaMedianlb_1(ii,jj,:)),'color',color_green);
    plot(0:opt.H,squeeze(etaMedianub_1(ii,jj,:)),'color',color_green);
    % plot(0:opt.H,squeeze(robCredlb_1(ii,jj,:)),'color',color_lightgreen,'LineStyle','--');
    % plot(0:opt.H,squeeze(robCredub_1(ii,jj,:)),'color',color_lightgreen,'LineStyle','--');
    plot(0:opt.H,squeeze(etaMedianlb_2(ii,jj,:)),'color',color_purp);
    plot(0:opt.H,squeeze(etaMedianub_2(ii,jj,:)),'color',color_purp);
    % plot(0:opt.H,squeeze(robCredlb_2(ii,jj,:)),'color',color_lightpurp,'LineStyle','--');
    % plot(0:opt.H,squeeze(robCredub_2(ii,jj,:)),'color',color_lightpurp,'LineStyle','--');
    line([0 opt.H],[0 0],'color','black','LineStyle',':');
    ylabel('%');
    if ii == 1
    title(shockNames(jj));
    end
    if jj == 1
    ylabel(strcat(varNames(ii),{' (%)'}));
    end
    if ii == 3
    xlabel('Horizon (months)');
    end
    % if ii == 1
    %     ylim([-10 10]);
    % elseif ii == 2
    %     ylim([-2 1]);
    % elseif ii == 3
    %     ylim([-10 15]);
    % end
end
end
cd Figures
print('oilMarket_restrInf','-depsc');


% Export figure data to Excel
hors = (0:opt.H)';
for ii = 1:3 % For each variable
    for jj = 1:3 % For each shock
        outmat = [hors,squeeze(etaMedianlb_0(ii,jj,:)),squeeze(etaMedianub_0(ii,jj,:)),...
            squeeze(etaMedianlb_1(ii,jj,:)),squeeze(etaMedianub_1(ii,jj,:)),...
            squeeze(etaMedianlb_2(ii,jj,:)),squeeze(etaMedianub_2(ii,jj,:))];
        writematrix(outmat,'GraphData_oilRestr.xlsx','Sheet',string(strcat(varNames(ii),shockNames(jj))));
    end
end

cd ..

%% Compute informativeness of restrictions statistic from GK21
% Based on ratio of widths of sets of posterior medians
restrInf_1 = 1 - (etaMedianub_1 - etaMedianlb_1)./(etaMedianub_0 - etaMedianlb_0);
restrInf_avg_1 = mean(restrInf_1,3); % Average across horizons
restrInf_2 = 1 - (etaMedianub_2 - etaMedianlb_2)./(etaMedianub_0 - etaMedianlb_0);
restrInf_avg_2 = mean(restrInf_2,3); % Average across horizons

restrInf_2v1 = (etaMedianub_2 - etaMedianlb_2)./(etaMedianub_1 - etaMedianlb_1);
restrInf_avg_2v1 = mean(restrInf_2v1,3);

% Construct table and export to Excel
restrInf_tab = cell([3,16]);
restrInf_tab(:,2:2:14) = {'&'};
restrInf_tab(:,end) = {'\\'};
restrInf_tab(:,1) = {'Activity','Production','Price'};
restrInf_tab(:,[3,5,7]) = num2cell(restrInf_avg_1);
restrInf_tab(:,[11, 13, 15]) = num2cell(restrInf_avg_2);
cd Results
writecell(restrInf_tab,'info_stats.xlsx','Sheet','restr');
cd ..
