% Estimate oil market model using different values of Delta.
% Compare computing time and effective sample size.

clear variables
close all
clc

addpath('auxFunctions');

Deltas = [1e-1 1e-2 1e-3 1e-4 1e-5 1e-6]';
effDrawph = zeros(length(Deltas),1);
runTime_stor = zeros(length(Deltas),1);

for dd = 1:length(Deltas)

    load('OilMarket_setup.mat');

    opt.Delta = Deltas(dd);

    fprintf(sprintf('Delta = %d\n',Deltas(dd)));

    svar_ss; 

    runTime_stor(dd) = runTime;

    % Compute number of effective draws per hour
    effDrawph(dd) = mean(ess/100)*opt.qDraws*opt.nonEmpty/(runTime/(60*60));
    sprintf('Number of effective draws per hour: %f',effDrawph(dd))


    cd Results
    save(sprintf('oilMarket_ss_Delta%d.mat',dd));
    cd ..
    clearvars -EXCEPT Deltas effDrawph runTime_stor dd

end
