% Examine performance of accept-reject sampling in empirical setting. 
% Model is oil market VAR in Antolin-Diaz and Rubio-Ramirez (2018). 
% Three-variable VAR with sign restrictions on all shocks, bounds on 
% 'elasticity' and narrative restrictions.
% Need to have run OilMarket_ss.m before running this script (at least up
% to point where preliminaries are saved in OilMarket_setup.mat).

% This version uses alternative method to check whether identified set is
% empty.

clear variables
close all
clc

addpath('auxFunctions');

% Load data, options, restrictions etc set up in OilMarket_ss.m
load('OilMarket_setup.mat');

% Obtain results using accept-reject
% At each draw of reduced-form parameters, terminate accept-reject 
% algorithm if no draws obtained satisfying restrictions after qMax draws
opt.qMax = 1e3; 
svar_ar_chebycheck;

drawph = opt.qDraws*opt.nonEmpty/(runTime/(60*60));
sprintf('Number of draws per hour: %f',drawph)

cd Results
save('OilMarket_ar_chebycheck.mat');
cd ..