% Plot posterior distributions of impulse responses in monetary policy
% application obtained using both samplers.

clear variables
close all
clc

cd Results
load('MonetaryPolicy_ss.mat');

etaMedian_ss = etaMedian;
credlb_ss = credlb;
credub_ss = credub;
clearvars -except etaMedian_ss credlb_ss credub_ss

load('MonetaryPolicy_ar.mat');
etaMedian_ar = etaMedian;
credlb_ar = credlb;
credub_ar = credub;
clearvars -except etaMedian_ar credlb_ar credub_ar etaMedian_ss credlb_ss credub_ss opt varNames

cd ..

figure;
for ii = 1:6
    subplot(2,3,ii);
    h1 = plot(0:opt.H,squeeze(etaMedian_ss(ii,1,:)),'color','blue');
    hold on;
    h2 = plot(0:opt.H,squeeze(etaMedian_ar(ii,:)),'color','red');
    h3 = plot(0:opt.H,squeeze(credlb_ss(ii,1,:)),'color','blue','LineStyle','--');
    h4 = plot(0:opt.H,squeeze(credlb_ar(ii,:)),'color','red','LineStyle','-.');
    plot(0:opt.H,squeeze(credub_ss(ii,1,:)),'color','blue','LineStyle','--');
    plot(0:opt.H,squeeze(credub_ar(ii,:)),'color','red','LineStyle','-.');
    line([0 opt.H],[0 0],'color','black','LineStyle',':');
    title(varNames(ii));
    if ii == 1
    ylabel('bps');
    else
        ylabel('%');
    end
    if ii > 3
    xlabel('Horizon (months)');
    end
end
cd Figures
print('monetarypolicy_bayes','-depsc');

% Export figure data to Excel
hors = (0:opt.H)';
for ii = 1:6 % For each variable
    outmat = [hors,squeeze(etaMedian_ss(ii,1,:)),squeeze(credlb_ss(ii,1,:)),squeeze(credub_ss(ii,1,:)),...
        etaMedian_ar(ii,:)',credlb_ar(ii,:)',credub_ar(ii,:)'];
    writematrix(outmat,'GraphData_MonetaryPolicy.xlsx','Sheet',string(varNames(ii)));
end

cd ..