

%% Load data

load_data;

% Learned variables only enter with a lag, but if last period is NaN then
% code gives an error. So fill period after end of data with some large
% value (shouldn't have any effect on estimation other than letting code
% run).
data{end,2:end} = 1e10;

addpath("..\functions")

%% MAIN RESULTS (reported in paper)

%% Table 6

%% headline + fuel

sample = dates(187:304);
mdl_data = data;
mdl_data.cons_exp = expect_nonrounded.all;
mdl_data.rba_exp = rba_exp.inflexp;
bound = 1;

learn_vars = {"CPI","Fuel"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

%% Figure 13

%% Plot fit - baseline vs with fuel

sample = dates(187:304);
mdl_data = data;
mdl_data.cons_exp = expect_nonrounded.all;
mdl_data.rba_exp = rba_exp.inflexp;
bound = 1;

learn_vars = {"CPI"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
plot_data = plot_fit(EstMdl,mdl_data.cons_exp(191:304),sample(5:end));
graphit_data = plot_data;

learn_vars = {"CPI","Fuel"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
plot_data = plot_fit(EstMdl,mdl_data.cons_exp(191:304),sample(5:end));
graphit_data.fuel = plot_data.predicted;

%% OTHER RESULTS - referred to but not reported in paper

%% Salient prices - one at a time, by subgroup

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI"};
bound = 1;

subgroup_names = expect_nonrounded.Properties.VariableNames(2:end);

salient_estimates = cell(length(subgroup_names),1);
salient_tstats = salient_estimates;

possible_vars = {"Food","AT","Housing","Clothing","Furnishings","Transport","Recreation","Health","Communication","Education","Insurance","Fuel","MV","Elec","Rents","housing_minus_rents","Trim","trimmed_gap"};
bound = 1; % Because hypothesis is that learners pay attention to these prices 'over and above' CPI.

tstats_tbl = table(possible_vars', 'VariableNames', {'Salient variable'});

for jj = 1:length(subgroup_names)

    mdl_data.cons_exp = expect_nonrounded{:,1+jj};

    logLs = NaN(length(possible_vars),1);
    bics = NaN(length(possible_vars),1);
    estParams = NaN(length(possible_vars),7);
    tstats = NaN(length(possible_vars),7);
    for ii = 1:length(possible_vars)
        learn_vars = {"CPI", possible_vars{ii}};
        [~,estParams_temp,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
        logLs(ii) = logL;
        bics(ii) = aicbic(logL,7,length(sample)-4);
        estParams(ii,:) = estParams_temp;
        tstats(ii,:) = estParams_temp./sqrt(diag(EstParamCov))';
    end

    tstats_tbl.(subgroup_names{jj}) = tstats(:,3);
    
    var_names = cellstr({"logL", "lambda", "CPI", "Salient", "c", "gfc", "eps", "eta"});
    spec_regs_tbl = array2table([logLs,estParams], ...
        'VariableNames', var_names);
    spec_regs_tbl.salient_var = possible_vars';
    sortrows(spec_regs_tbl,'logL')
    
    var_names = cellstr({"logL", "lambda", "CPI", "Salient", "c", "gfc","eps", "eta"});
    spec_regs_tstat_tbl = array2table([logLs,tstats], ...
        'VariableNames', var_names);
    spec_regs_tstat_tbl.salient_var = possible_vars';

    salient_estimates{jj} =  spec_regs_tbl;
    salient_tstats{jj} = spec_regs_tstat_tbl;

end

%% Fuel

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI","Fuel"};
bound = 1;

subgroup_names = expect_nonrounded.Properties.VariableNames(2:end);

param_names = {'Lambda'; 'CPI'; 'Fuel'; 'c'; 'GFC'; 'eps'; 'eta'};
stats_names = [repmat({'est'}, [length(param_names) 1]); repmat({'se'}, [length(param_names) 1]); repmat({'tstat'}, [length(param_names) 1])];
results_tbl = table(repmat(param_names, [3,1]), stats_names, 'VariableNames', {'Param', 'Stat'});

for ii = 1:length(subgroup_names)

    mdl_data.cons_exp = expect_nonrounded{:,1+ii};

    [EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

    se = sqrt(diag(EstParamCov));
    tstats = estParams'./se;

    results_tbl.(subgroup_names{ii}) = [estParams'; se; tstats];

end

%% Salient prices - one at a time on top of fuel

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
bound = 1;

subgroup_names = expect_nonrounded.Properties.VariableNames(2:end);

salient_estimates = cell(length(subgroup_names),1);
salient_tstats = salient_estimates;

possible_vars = {"Food","AT","Housing","Clothing","Furnishings","Transport","Recreation","Health","Communication","Education","Insurance","Fuel","MV","Elec","Rents","housing_minus_rents","Trim","trimmed_gap"};
bound = 1; % Because hypothesis is that learners pay attention to these prices 'over and above' CPI.

for jj = 1:length(subgroup_names)

    mdl_data.cons_exp = expect_nonrounded{:,1+jj};

    logLs = NaN(length(possible_vars),1);
    bics = NaN(length(possible_vars),1);
    estParams = NaN(length(possible_vars),8);
    tstats = NaN(length(possible_vars),8);
    for ii = 1:length(possible_vars)
        learn_vars = {"CPI", "Fuel", possible_vars{ii}};
        [~,estParams_temp,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
        logLs(ii) = logL;
        bics(ii) = aicbic(logL,7,length(sample)-4);
        estParams(ii,:) = estParams_temp;
        tstats(ii,:) = estParams_temp./sqrt(diag(EstParamCov))';
    end
    
    var_names = cellstr({"logL", "lambda", "CPI", "Fuel", "Salient", "c", "gfc", "eps", "eta"});
    spec_regs_tbl = array2table([logLs,estParams], ...
        'VariableNames', var_names);
    spec_regs_tbl.salient_var = possible_vars';
    sortrows(spec_regs_tbl,'logL')
    
    var_names = cellstr({"logL", "lambda", "CPI", "Fuel", "Salient", "c", "gfc","eps", "eta"});
    spec_regs_tstat_tbl = array2table([logLs,tstats], ...
        'VariableNames', var_names);
    spec_regs_tstat_tbl.salient_var = possible_vars';

    salient_estimates{jj} =  spec_regs_tbl;
    salient_tstats{jj} = spec_regs_tstat_tbl;

end

%% Many salient

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
bound = 1;

learn_vars = {"CPI","Fuel","MV","Furnishings","Housing"};
param_names = {'Lambda'; 'CPI'; 'Fuel'; 'MV'; 'Furnishings'; 'Housing'; 'c'; 'GFC'; 'eps'; 'eta'};

learn_vars = {"CPI","Fuel","MV","Furnishings","AT","Rents","housing_minus_rents"};
param_names = {'Lambda'; 'CPI'; 'Fuel'; 'MV'; 'Furnishings'; 'AT'; 'Rents'; 'Housing minus rents'; 'c'; 'GFC'; 'eps'; 'eta'};

%learn_vars = {"CPI","trimmed_gap", "Fuel","MV","Furnishings","AT","Rents","housing_minus_rents"};
%param_names = {'Lambda'; 'CPI'; 'Trimmed gap'; 'Fuel'; 'MV'; 'Furnishings'; 'AT'; 'Rents'; 'Housing minus rents'; 'c'; 'GFC'; 'eps'; 'eta'};

bound = 1;

subgroup_names = expect_nonrounded.Properties.VariableNames(2:end);

stats_names = [repmat({'est'}, [length(param_names) 1]); repmat({'se'}, [length(param_names) 1]); repmat({'tstat'}, [length(param_names) 1])];
results_tbl = table(repmat(param_names, [3,1]), stats_names, 'VariableNames', {'Param', 'Stat'});

for ii = 1:length(subgroup_names)

    mdl_data.cons_exp = expect_nonrounded{:,1+ii};

    [EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

    se = sqrt(diag(EstParamCov));
    tstats = estParams'./se;

    results_tbl.(subgroup_names{ii}) = [estParams'; se; tstats];

end

%% Cost of living

sample = dates(201:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
bound = 1;

%learn_vars = {"CPI","col_employee","col_pensioner","col_welfare","col_retire"};
%learn_vars = {"CPI","col_employee","col_pensioner","col_retire"};
learn_vars = {"CPI","col_employee"};
bound = 1;

subgroup_names = expect_nonrounded.Properties.VariableNames(2:end);

param_names = {'Lambda'; 'CPI'; 'COL_emp'; 'COL_pen'; 'COL_welf'; 'COL_ret'; 'c'; 'GFC'; 'eps'; 'eta'};
param_names = {'Lambda'; 'CPI'; 'COL_emp'; 'c'; 'GFC'; 'eps'; 'eta'};
stats_names = [repmat({'est'}, [length(param_names) 1]); repmat({'se'}, [length(param_names) 1]); repmat({'tstat'}, [length(param_names) 1])];
results_tbl = table(repmat(param_names, [3,1]), stats_names, 'VariableNames', {'Param', 'Stat'});

for ii = 1:length(subgroup_names)

    mdl_data.cons_exp = expect_nonrounded{:,1+ii};

    [EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

    se = sqrt(diag(EstParamCov));
    tstats = estParams'./se;

    results_tbl.(subgroup_names{ii}) = [estParams'; se; tstats];

end

%% Housing lending

% Just housing lending

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI","housing_lending"};
bound = 1;

subgroup_names = expect_nonrounded.Properties.VariableNames(2:end);

param_names = {'Lambda'; 'CPI'; 'mortgage'; 'c'; 'GFC'; 'eps'; 'eta'};
stats_names = [repmat({'est'}, [length(param_names) 1]); repmat({'se'}, [length(param_names) 1]); repmat({'tstat'}, [length(param_names) 1])];
results_tbl = table(repmat(param_names, [3,1]), stats_names, 'VariableNames', {'Param', 'Stat'});

for ii = 1:length(subgroup_names)

    mdl_data.cons_exp = expect_nonrounded{:,1+ii};

    [EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

    se = sqrt(diag(EstParamCov));
    tstats = estParams'./se;

    results_tbl.(subgroup_names{ii}) = [estParams'; se; tstats];

end

%% Cash rate

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI","IR"};
bound = 1;

subgroup_names = expect_nonrounded.Properties.VariableNames(2:end);

param_names = {'Lambda'; 'CPI'; 'cash rate'; 'c'; 'GFC'; 'eps'; 'eta'};
stats_names = [repmat({'est'}, [length(param_names) 1]); repmat({'se'}, [length(param_names) 1]); repmat({'tstat'}, [length(param_names) 1])];
results_tbl = table(repmat(param_names, [3,1]), stats_names, 'VariableNames', {'Param', 'Stat'});

for ii = 1:length(subgroup_names)

    mdl_data.cons_exp = expect_nonrounded{:,1+ii};

    [EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

    se = sqrt(diag(EstParamCov));
    tstats = estParams'./se;

    results_tbl.(subgroup_names{ii}) = [estParams'; se; tstats];

end


%% Fuel and cash rate

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI","Fuel","IR"};
bound = 1;

subgroup_names = expect_nonrounded.Properties.VariableNames(2:end);

param_names = {'Lambda'; 'CPI'; 'fuel'; 'cash rate'; 'c'; 'GFC'; 'eps'; 'eta'};
stats_names = [repmat({'est'}, [length(param_names) 1]); repmat({'se'}, [length(param_names) 1]); repmat({'tstat'}, [length(param_names) 1])];
results_tbl = table(repmat(param_names, [3,1]), stats_names, 'VariableNames', {'Param', 'Stat'});

for ii = 1:length(subgroup_names)

    mdl_data.cons_exp = expect_nonrounded{:,1+ii};

    [EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

    se = sqrt(diag(EstParamCov));
    tstats = estParams'./se;

    results_tbl.(subgroup_names{ii}) = [estParams'; se; tstats];

end



