% Plot results from disaggregated exercise.

clear variables
% close all
% clc

addpath('auxFunctions');

cd('Results');
load('disaggregated_results.mat');
cd ..

%% Plot contributions of supply shock
cd Figures
plotDates = dates(opt.p+1:end);

graphNames = catNames;

for ii = 1:N

figure
h1 = plot(plotDates,Et_ye(:,ii),'color','black','LineWidth',2);
hold on;
h2 = plot(plotDates,HD_ye_lb(:,ii),'color','blue','LineStyle','--');
plot(plotDates,HD_ye_ub(:,ii),'color','blue','LineStyle','--');
patch([plotDates; flip(plotDates)],[HD_ye_lb(:,ii); flip(HD_ye_ub(:,ii))], ...
    'blue','FaceAlpha','0.1','EdgeColor','none');
xlims = xlim;
line(xlims,[0, 0],'color','black','LineStyle',':');
title(graphNames{ii});
ylabel('ppt');
legend([h1 h2],{'$$\pi_t$$','Set of historical decompositions'},...
    'Location','NorthWest','Interpreter','LaTeX')
legend boxoff;
ax = gca;
ax.FontSize = 14;
print(sprintf('pce_%s',num2str(ii)),'-depsc');
print(sprintf('pce_%s',num2str(ii)),'-dpng');

end

% Aggregate
figure
h1 = plot(plotDates,Et_ye_agg(:,1),'color','black','LineWidth',2);
hold on;
h2 = plot(plotDates,HD_ye_lb_agg(:,1),'color','blue','LineStyle','--');
plot(plotDates,HD_ye_ub_agg(:,1),'color','blue','LineStyle','--');
patch([plotDates; flip(plotDates)],[HD_ye_lb_agg(:,1); flip(HD_ye_ub_agg(:,1))], ...
    'blue','FaceAlpha','0.1','EdgeColor','none');
xlims = xlim;
line(xlims,[0, 0],'color','black','LineStyle',':');
title('Aggregate');
ylabel('ppt');
legend([h1 h2],{'$$\pi_t$$','Set of historical decompositions'},...
    'Location','NorthWest','Interpreter','LaTeX')
legend boxoff;
ax = gca;
ax.FontSize = 14;
print('pce_aggregate','-depsc');
print('pce_aggregate','-dpng');

% Aggregate based on disaggregate decomps ('bottom-up')
figure
h1 = plot(plotDates,Et_ye_sum,'color','black','LineWidth',2);
hold on;
h2 = plot(plotDates,HD_ye_sum_lb,'color','blue','LineStyle','--');
plot(plotDates,HD_ye_sum_ub,'color','blue','LineStyle','--');
patch([plotDates; flip(plotDates)],[HD_ye_sum_lb; flip(HD_ye_sum_ub)], ...
    'blue','FaceAlpha','0.1','EdgeColor','none');
xlims = xlim;
line(xlims,[0, 0],'color','black','LineStyle',':');
title('Derived from disaggregated decompositions');
ylabel('ppt');
legend([h1 h2],{'$$\pi_t$$','Set of historical decompositions'},...
    'Location','NorthWest','Interpreter','LaTeX')
legend boxoff;
ax = gca;
ax.FontSize = 14;
print('pce_aggregate_derived','-depsc');
print('pce_aggregate_derived','-dpng');

% Histogram of correlations
figure;
h = histogram(rho,'Normalization','probability','FaceColor','blue');
xlabel('$$\rho$$','interpreter','LaTeX');
ylabel('%');
% title('Histogram of Correlations Between One-step-ahead Forecast Errors');
ax = gca;
ax.FontSize = 14;
print('pce_correlations','-depsc');
print('pce_correlations','-dpng');

cd ..
